/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScreenShotHelper {
    private static final Logger field_148261_a = LogManager.getLogger();
    private static final DateFormat field_74295_a = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static void func_148260_a(File gameDirectory, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        ScreenShotHelper.func_148259_a((File)gameDirectory, (String)null, (int)width, (int)height, (Framebuffer)buffer, messageConsumer);
    }

    public static void func_148259_a(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> ScreenShotHelper.func_228051_b_((File)gameDirectory, (String)screenshotName, (int)width, (int)height, (Framebuffer)buffer, (Consumer)messageConsumer));
        } else {
            ScreenShotHelper.func_228051_b_((File)gameDirectory, (String)screenshotName, (int)width, (int)height, (Framebuffer)buffer, messageConsumer);
        }
    }

    private static void func_228051_b_(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        boolean resize;
        Minecraft mc = Config.getMinecraft();
        MainWindow mainWindow = mc.func_228018_at_();
        GameSettings gameSettings = Config.getGameSettings();
        int fbWidth = mainWindow.func_198109_k();
        int fbHeight = mainWindow.func_198091_l();
        int guiScaleOld = gameSettings.field_74335_Z;
        int guiScale = mainWindow.func_216521_a(mc.field_71474_y.field_74335_Z, mc.field_71474_y.field_211842_aO);
        int mul = Config.getScreenshotSize();
        boolean bl = resize = GLX.isUsingFBOs() && mul > 1;
        if (resize) {
            gameSettings.field_74335_Z = guiScale * mul;
            mainWindow.resizeFramebuffer(fbWidth * mul, fbHeight * mul);
            GlStateManager.func_227626_N_();
            GlStateManager.clear((int)16640);
            mc.func_147110_a().func_147610_a(true);
            GlStateManager.func_227619_H_();
            mc.field_71460_t.func_195458_a(mc.func_184121_ak(), System.nanoTime(), true);
        }
        NativeImage nativeimage = ScreenShotHelper.func_198052_a((int)width, (int)height, (Framebuffer)buffer);
        if (resize) {
            mc.func_147110_a().func_147609_e();
            GlStateManager.func_227627_O_();
            Config.getGameSettings().field_74335_Z = guiScaleOld;
            mainWindow.resizeFramebuffer(fbWidth, fbHeight);
        }
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File file2 = screenshotName == null ? ScreenShotHelper.func_74290_a((File)file1) : new File(file1, screenshotName);
        Object event = null;
        if (Reflector.ForgeHooksClient_onScreenshot.exists()) {
            event = Reflector.call(Reflector.ForgeHooksClient_onScreenshot, nativeimage, file2);
            if (Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0])) {
                ITextComponent msg = (ITextComponent)Reflector.call(event, Reflector.ScreenshotEvent_getCancelMessage, new Object[0]);
                messageConsumer.accept(msg);
                return;
            }
            file2 = (File)Reflector.call(event, Reflector.ScreenshotEvent_getScreenshotFile, new Object[0]);
        }
        File target = file2;
        Object eventF = event;
        Util.func_240992_g_().execute(() -> {
            try {
                nativeimage.func_209271_a(target);
                IFormattableTextComponent itextcomponent = new StringTextComponent(target.getName()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(p_238335_1_ -> p_238335_1_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                if (eventF != null && Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]) != null) {
                    messageConsumer.accept((ITextComponent)Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]));
                } else {
                    messageConsumer.accept((ITextComponent)new TranslationTextComponent("screenshot.success", new Object[]{itextcomponent}));
                }
            }
            catch (Exception exception) {
                field_148261_a.warn("Couldn't save screenshot", (Throwable)exception);
                messageConsumer.accept((ITextComponent)new TranslationTextComponent("screenshot.failure", new Object[]{exception.getMessage()}));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage func_198052_a(int width, int height, Framebuffer framebufferIn) {
        width = framebufferIn.field_147622_a;
        height = framebufferIn.field_147620_b;
        NativeImage nativeimage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)framebufferIn.field_147617_g);
        nativeimage.func_195717_a(0, true);
        nativeimage.func_195710_e();
        return nativeimage;
    }

    private static File func_74290_a(File gameDirectory) {
        String s2 = field_74295_a.format(new Date());
        int i2 = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s2 + (i2 == 1 ? "" : "_" + i2) + ".png")).exists()) {
            ++i2;
        }
        return file1;
    }
}

