/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IdentityPalette;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.chunk.Chunk;
import net.optifine.ChunkDataOF;
import net.optifine.ChunkSectionDataOF;

public class ChunkSection {
    private static final IPalette<BlockState> field_205512_a = new IdentityPalette(Block.field_176229_d, (Object)Blocks.field_150350_a.func_176223_P());
    private final int field_76684_a;
    private short field_76682_b;
    private short field_76683_c;
    private short field_206918_e;
    private final PalettedContainer<BlockState> field_177488_d;
    public static final ThreadLocal<ChunkDataOF> THREAD_CHUNK_DATA_OF = new ThreadLocal();

    public ChunkSection(int yBaseIn) {
        this(yBaseIn, 0, 0, 0);
    }

    public ChunkSection(int yBaseIn, short blockRefCountIn, short blockTickRefCountIn, short fluidRefCountIn) {
        this.field_76684_a = yBaseIn;
        this.field_76682_b = blockRefCountIn;
        this.field_76683_c = blockTickRefCountIn;
        this.field_206918_e = fluidRefCountIn;
        this.field_177488_d = new PalettedContainer(field_205512_a, Block.field_176229_d, NBTUtil::func_190008_d, NBTUtil::func_190009_a, (Object)Blocks.field_150350_a.func_176223_P());
    }

    public BlockState func_177485_a(int x2, int y, int z) {
        return (BlockState)this.field_177488_d.func_186016_a(x2, y, z);
    }

    public FluidState func_206914_b(int x2, int y, int z) {
        return ((BlockState)this.field_177488_d.func_186016_a(x2, y, z)).func_204520_s();
    }

    public void func_222635_a() {
        this.field_177488_d.func_210459_b();
    }

    public void func_222637_b() {
        this.field_177488_d.func_210460_c();
    }

    public BlockState func_222629_a(int x2, int y, int z, BlockState blockStateIn) {
        return this.func_177484_a(x2, y, z, blockStateIn, true);
    }

    public BlockState func_177484_a(int x2, int y, int z, BlockState state, boolean useLocks) {
        BlockState blockstate = useLocks ? (BlockState)this.field_177488_d.func_222641_a(x2, y, z, (Object)state) : (BlockState)this.field_177488_d.func_222639_b(x2, y, z, (Object)state);
        FluidState fluidstate = blockstate.func_204520_s();
        FluidState fluidstate1 = state.func_204520_s();
        if (!blockstate.func_196958_f()) {
            this.field_76682_b = (short)(this.field_76682_b - 1);
            if (blockstate.func_204519_t()) {
                this.field_76683_c = (short)(this.field_76683_c - 1);
            }
        }
        if (!fluidstate.func_206888_e()) {
            this.field_206918_e = (short)(this.field_206918_e - 1);
        }
        if (!state.func_196958_f()) {
            this.field_76682_b = (short)(this.field_76682_b + 1);
            if (state.func_204519_t()) {
                this.field_76683_c = (short)(this.field_76683_c + 1);
            }
        }
        if (!fluidstate1.func_206888_e()) {
            this.field_206918_e = (short)(this.field_206918_e + 1);
        }
        return blockstate;
    }

    public boolean func_76663_a() {
        return this.field_76682_b == 0;
    }

    public static boolean func_222628_a(@Nullable ChunkSection section) {
        return section == Chunk.field_186036_a || section.func_76663_a();
    }

    public boolean func_206915_b() {
        return this.func_76675_b() || this.func_206917_d();
    }

    public boolean func_76675_b() {
        return this.field_76683_c > 0;
    }

    public boolean func_206917_d() {
        return this.field_206918_e > 0;
    }

    public int func_222632_g() {
        return this.field_76684_a;
    }

    public void func_76672_e() {
        ChunkSectionDataOF csd;
        int index;
        ChunkSectionDataOF[] csds;
        ChunkDataOF chunkDataOF = (ChunkDataOF)THREAD_CHUNK_DATA_OF.get();
        if (chunkDataOF != null && (csds = chunkDataOF.getChunkSectionDatas()) != null && (index = this.field_76684_a >> 4) >= 0 && index < csds.length && (csd = csds[index]) != null) {
            this.field_76682_b = csd.getBlockRefCount();
            this.field_76683_c = csd.getTickRefCount();
            this.field_206918_e = csd.getFluidRefCount();
            csds[index] = null;
            return;
        }
        this.field_76682_b = 0;
        this.field_76683_c = 0;
        this.field_206918_e = 0;
        this.field_177488_d.func_225497_a((p_225496_1_, p_225496_2_) -> {
            FluidState fluidstate = p_225496_1_.func_204520_s();
            if (!p_225496_1_.func_196958_f()) {
                this.field_76682_b = (short)(this.field_76682_b + p_225496_2_);
                if (p_225496_1_.func_204519_t()) {
                    this.field_76683_c = (short)(this.field_76683_c + p_225496_2_);
                }
            }
            if (!fluidstate.func_206888_e()) {
                this.field_76682_b = (short)(this.field_76682_b + p_225496_2_);
                if (fluidstate.func_206890_h()) {
                    this.field_206918_e = (short)(this.field_206918_e + p_225496_2_);
                }
            }
        });
    }

    public PalettedContainer<BlockState> func_186049_g() {
        return this.field_177488_d;
    }

    public void func_222634_a(PacketBuffer packetBufferIn) {
        this.field_76682_b = packetBufferIn.readShort();
        this.field_177488_d.func_186010_a(packetBufferIn);
    }

    public void func_222630_b(PacketBuffer packetBufferIn) {
        packetBufferIn.writeShort((int)this.field_76682_b);
        this.field_177488_d.func_186009_b(packetBufferIn);
    }

    public int func_222633_j() {
        return 2 + this.field_177488_d.func_186018_a();
    }

    public boolean func_235962_a_(Predicate<BlockState> state) {
        return this.field_177488_d.func_235963_a_(state);
    }

    public short getBlockRefCount() {
        return this.field_76682_b;
    }

    public short getTickRefCount() {
        return this.field_76683_c;
    }

    public short getFluidRefCount() {
        return this.field_206918_e;
    }
}

