/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GLX;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.optifine.DynamicLights;
import net.optifine.GlErrors;
import net.optifine.VersionCheckThread;
import net.optifine.config.GlVersion;
import net.optifine.gui.GuiMessage;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.16.1";
    public static final String OF_EDITION = "HD_U";
    public static final String OF_RELEASE = "G2";
    public static final String VERSION = "OptiFine_1.16.1_HD_U_G2";
    private static String build = null;
    private static String newRelease = null;
    private static boolean notify64BitJava = false;
    public static String openGlVersion = null;
    public static String openGlRenderer = null;
    public static String openGlVendor = null;
    public static String[] openGlExtensions = null;
    public static GlVersion glVersion = null;
    public static GlVersion glslVersion = null;
    public static int minecraftVersionInt = -1;
    public static boolean fancyFogAvailable = false;
    public static boolean occlusionAvailable = false;
    private static dmb gameSettings = null;
    private static dlx minecraft = dlx.B();
    private static boolean initialized = false;
    private static Thread minecraftThread = null;
    private static int antialiasingLevel = 0;
    private static int availableProcessors = 0;
    public static boolean zoomMode = false;
    public static boolean zoomSmoothCamera = false;
    private static int texturePackClouds = 0;
    private static boolean fullscreenModeChecked = false;
    private static boolean desktopModeChecked = false;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean logDetail = System.getProperty("log.detail", "false").equals("true");
    private static String mcDebugLast = null;
    private static int fpsMinLast = 0;
    private static int chunkUpdatesLast = 0;
    public static final uh LOCATION_MOJANG_LOGO = new uh("textures/gui/title/mojangstudios.png");
    private static elu textureMapTerrain;
    private static long timeLastFrameMs;
    private static long averageFrameTimeMs;

    private Config() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersionDebug() {
        StringBuffer sb = new StringBuffer(32);
        if (Config.isDynamicLights()) {
            sb.append("DL: ");
            sb.append(String.valueOf(DynamicLights.getCount()));
            sb.append(", ");
        }
        sb.append(VERSION);
        String shaderPack = Shaders.getShaderPackName();
        if (shaderPack != null) {
            sb.append(", ");
            sb.append(shaderPack);
        }
        return sb.toString();
    }

    public static void initGameSettings(dmb settings) {
        if (gameSettings != null) {
            return;
        }
        gameSettings = settings;
        Config.updateAvailableProcessors();
        ReflectorForge.putLaunchBlackboard("optifine.ForgeSplashCompatible", Boolean.TRUE);
        antialiasingLevel = Config.gameSettings.ofAaLevel;
    }

    public static void initDisplay() {
        Config.checkInitialized();
        minecraftThread = Thread.currentThread();
        Config.updateThreadPriorities();
        Shaders.startup(dlx.B());
    }

    public static void checkInitialized() {
        if (initialized) {
            return;
        }
        if (dlx.B().aB() == null) {
            return;
        }
        initialized = true;
        Config.checkOpenGlCaps();
        Config.startVersionCheckThread();
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("Build: " + Config.getBuild());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + GLFW.glfwGetVersionString());
        openGlVersion = GL11.glGetString((int)7938);
        openGlRenderer = GL11.glGetString((int)7937);
        openGlVendor = GL11.glGetString((int)7936);
        Config.log("OpenGL: " + openGlRenderer + ", version " + openGlVersion + ", " + openGlVendor);
        Config.log("OpenGL Version: " + Config.getOpenGlVersionString());
        GLCapabilities glCapabilities = GL.getCapabilities();
        if (!glCapabilities.OpenGL12) {
            Config.log("OpenGL Mipmap levels: Not available (GL12.GL_TEXTURE_MAX_LEVEL)");
        }
        if (!(fancyFogAvailable = glCapabilities.GL_NV_fog_distance)) {
            Config.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!(occlusionAvailable = glCapabilities.GL_ARB_occlusion_query)) {
            Config.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
        int maxTexSize = TextureUtils.getGLMaximumTextureSize();
        Config.dbg("Maximum texture size: " + maxTexSize + "x" + maxTexSize);
    }

    public static String getBuild() {
        if (build == null) {
            try {
                InputStream in = Config.getOptiFineResourceStream("/buildof.txt");
                if (in == null) {
                    return null;
                }
                build = Config.readLines(in)[0];
            }
            catch (Exception e2) {
                Config.warn("" + e2.getClass().getName() + ": " + e2.getMessage());
                build = "";
            }
        }
        return build;
    }

    public static InputStream getOptiFineResourceStream(String name) {
        InputStream in = ReflectorForge.getOptiFineResourceStream(name);
        if (in != null) {
            return in;
        }
        return Config.class.getResourceAsStream(name);
    }

    public static boolean isFancyFogAvailable() {
        return fancyFogAvailable;
    }

    public static boolean isOcclusionAvailable() {
        return occlusionAvailable;
    }

    public static int getMinecraftVersionInt() {
        if (minecraftVersionInt < 0) {
            String[] verStrs = Config.tokenize(MC_VERSION, ".");
            int ver = 0;
            if (verStrs.length > 0) {
                ver += 10000 * Config.parseInt(verStrs[0], 0);
            }
            if (verStrs.length > 1) {
                ver += 100 * Config.parseInt(verStrs[1], 0);
            }
            if (verStrs.length > 2) {
                ver += 1 * Config.parseInt(verStrs[2], 0);
            }
            minecraftVersionInt = ver;
        }
        return minecraftVersionInt;
    }

    public static String getOpenGlVersionString() {
        GlVersion ver = Config.getGlVersion();
        String verStr = "" + ver.getMajor() + "." + ver.getMinor() + "." + ver.getRelease();
        return verStr;
    }

    private static GlVersion getGlVersionLwjgl() {
        GLCapabilities glCapabilities = GL.getCapabilities();
        if (glCapabilities.OpenGL44) {
            return new GlVersion(4, 4);
        }
        if (glCapabilities.OpenGL43) {
            return new GlVersion(4, 3);
        }
        if (glCapabilities.OpenGL42) {
            return new GlVersion(4, 2);
        }
        if (glCapabilities.OpenGL41) {
            return new GlVersion(4, 1);
        }
        if (glCapabilities.OpenGL40) {
            return new GlVersion(4, 0);
        }
        if (glCapabilities.OpenGL33) {
            return new GlVersion(3, 3);
        }
        if (glCapabilities.OpenGL32) {
            return new GlVersion(3, 2);
        }
        if (glCapabilities.OpenGL31) {
            return new GlVersion(3, 1);
        }
        if (glCapabilities.OpenGL30) {
            return new GlVersion(3, 0);
        }
        if (glCapabilities.OpenGL21) {
            return new GlVersion(2, 1);
        }
        if (glCapabilities.OpenGL20) {
            return new GlVersion(2, 0);
        }
        if (glCapabilities.OpenGL15) {
            return new GlVersion(1, 5);
        }
        if (glCapabilities.OpenGL14) {
            return new GlVersion(1, 4);
        }
        if (glCapabilities.OpenGL13) {
            return new GlVersion(1, 3);
        }
        if (glCapabilities.OpenGL12) {
            return new GlVersion(1, 2);
        }
        if (glCapabilities.OpenGL11) {
            return new GlVersion(1, 1);
        }
        return new GlVersion(1, 0);
    }

    public static GlVersion getGlVersion() {
        if (glVersion == null) {
            String verStr = GL11.glGetString((int)7938);
            glVersion = Config.parseGlVersion(verStr, null);
            if (glVersion == null) {
                glVersion = Config.getGlVersionLwjgl();
            }
            if (glVersion == null) {
                glVersion = new GlVersion(1, 0);
            }
        }
        return glVersion;
    }

    public static GlVersion getGlslVersion() {
        String verStr;
        if (glslVersion == null && (glslVersion = Config.parseGlVersion(verStr = GL11.glGetString((int)35724), null)) == null) {
            glslVersion = new GlVersion(1, 10);
        }
        return glslVersion;
    }

    public static GlVersion parseGlVersion(String versionString, GlVersion def) {
        try {
            if (versionString == null) {
                return def;
            }
            Pattern REGEXP_VERSION = Pattern.compile("([0-9]+)\\.([0-9]+)(\\.([0-9]+))?(.+)?");
            Matcher matcher = REGEXP_VERSION.matcher(versionString);
            if (!matcher.matches()) {
                return def;
            }
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int release = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            String suffix = matcher.group(5);
            return new GlVersion(major, minor, release, suffix);
        }
        catch (Exception e2) {
            Config.error("", e2);
            return def;
        }
    }

    public static String[] getOpenGlExtensions() {
        if (openGlExtensions == null) {
            openGlExtensions = Config.detectOpenGlExtensions();
        }
        return openGlExtensions;
    }

    private static String[] detectOpenGlExtensions() {
        try {
            int countExt;
            GlVersion ver = Config.getGlVersion();
            if (ver.getMajor() >= 3 && (countExt = GL11.glGetInteger((int)33309)) > 0) {
                String[] exts = new String[countExt];
                for (int i2 = 0; i2 < countExt; ++i2) {
                    exts[i2] = GL30.glGetStringi((int)7939, (int)i2);
                }
                return exts;
            }
        }
        catch (Exception e2) {
            Config.error("", e2);
        }
        try {
            String extStr = GL11.glGetString((int)7939);
            String[] exts = extStr.split(" ");
            return exts;
        }
        catch (Exception e3) {
            Config.error("", e3);
            return new String[0];
        }
    }

    public static void updateThreadPriorities() {
        Config.updateAvailableProcessors();
        int ELEVATED_PRIORITY = 8;
        if (Config.isSingleProcessor()) {
            if (Config.isSmoothWorld()) {
                minecraftThread.setPriority(10);
                Config.setThreadPriority("Server thread", 1);
            } else {
                minecraftThread.setPriority(5);
                Config.setThreadPriority("Server thread", 5);
            }
        } else {
            minecraftThread.setPriority(10);
            Config.setThreadPriority("Server thread", 5);
        }
    }

    private static void setThreadPriority(String prefix, int priority) {
        try {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            if (tg == null) {
                return;
            }
            int num = (tg.activeCount() + 10) * 2;
            Thread[] ts2 = new Thread[num];
            tg.enumerate(ts2, false);
            for (int i2 = 0; i2 < ts2.length; ++i2) {
                Thread t2 = ts2[i2];
                if (t2 == null || !t2.getName().startsWith(prefix)) continue;
                t2.setPriority(priority);
            }
        }
        catch (Throwable e2) {
            Config.warn(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public static boolean isMinecraftThread() {
        return Thread.currentThread() == minecraftThread;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread vct = new VersionCheckThread();
        vct.start();
    }

    public static boolean isMipmaps() {
        return Config.gameSettings.A > 0;
    }

    public static int getMipmapLevels() {
        return Config.gameSettings.A;
    }

    public static int getMipmapType() {
        switch (Config.gameSettings.ofMipmapType) {
            case 0: {
                return 9986;
            }
            case 1: {
                return 9986;
            }
            case 2: {
                if (Config.isMultiTexture()) {
                    return 9985;
                }
                return 9986;
            }
            case 3: {
                if (Config.isMultiTexture()) {
                    return 9987;
                }
                return 9986;
            }
        }
        return 9986;
    }

    public static boolean isUseAlphaFunc() {
        float alphaFuncLevel = Config.getAlphaFuncLevel();
        return alphaFuncLevel > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogFancy() {
        if (!Config.isFancyFogAvailable()) {
            return false;
        }
        return Config.gameSettings.ofFogType == 2;
    }

    public static boolean isFogFast() {
        return Config.gameSettings.ofFogType == 1;
    }

    public static boolean isFogOff() {
        return Config.gameSettings.ofFogType == 3;
    }

    public static boolean isFogOn() {
        return Config.gameSettings.ofFogType != 3;
    }

    public static float getFogStart() {
        return Config.gameSettings.ofFogStart;
    }

    public static void detail(String s2) {
        if (logDetail) {
            LOGGER.info("[OptiFine] " + s2);
        }
    }

    public static void dbg(String s2) {
        LOGGER.info("[OptiFine] " + s2);
    }

    public static void warn(String s2) {
        LOGGER.warn("[OptiFine] " + s2);
    }

    public static void warn(String s2, Throwable t2) {
        LOGGER.warn("[OptiFine] " + s2, t2);
    }

    public static void error(String s2) {
        LOGGER.error("[OptiFine] " + s2);
    }

    public static void error(String s2, Throwable t2) {
        LOGGER.error("[OptiFine] " + s2, t2);
    }

    public static void log(String s2) {
        Config.dbg(s2);
    }

    public static int getUpdatesPerFrame() {
        return Config.gameSettings.ofChunkUpdates;
    }

    public static boolean isDynamicUpdates() {
        return Config.gameSettings.ofChunkUpdatesDynamic;
    }

    public static boolean isGraphicsFancy() {
        return Config.gameSettings.f != dlr.a;
    }

    public static boolean isGraphicsFabulous() {
        return Config.gameSettings.f == dlr.c;
    }

    public static boolean isRainFancy() {
        if (Config.gameSettings.ofRain == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofRain == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.gameSettings.ofClouds != 0) {
            return Config.gameSettings.ofClouds == 2;
        }
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isFancy();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 2;
        }
        return Config.isGraphicsFancy();
    }

    public static boolean isCloudsOff() {
        if (Config.gameSettings.ofClouds != 0) {
            return Config.gameSettings.ofClouds == 3;
        }
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isOff();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 3;
        }
        return false;
    }

    public static void updateTexturePackClouds() {
        texturePackClouds = 0;
        abc rm = Config.getResourceManager();
        if (rm == null) {
            return;
        }
        try {
            InputStream in = rm.a(new uh("optifine/color.properties")).b();
            if (in == null) {
                return;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String cloudStr = props.getProperty("clouds");
            if (cloudStr == null) {
                return;
            }
            Config.dbg("Texture pack clouds: " + cloudStr);
            cloudStr = cloudStr.toLowerCase();
            if (cloudStr.equals("fast")) {
                texturePackClouds = 1;
            }
            if (cloudStr.equals("fancy")) {
                texturePackClouds = 2;
            }
            if (cloudStr.equals("off")) {
                texturePackClouds = 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enm getModelManager() {
        return Config.minecraft.ac().modelManager;
    }

    public static boolean isTreesFancy() {
        if (Config.gameSettings.ofTrees == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofTrees != 1;
    }

    public static boolean isTreesSmart() {
        return Config.gameSettings.ofTrees == 4;
    }

    public static boolean isCullFacesLeaves() {
        if (Config.gameSettings.ofTrees == 0) {
            return !Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofTrees == 4;
    }

    public static boolean isDroppedItemsFancy() {
        if (Config.gameSettings.ofDroppedItems == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofDroppedItems == 2;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static long limit(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double limit(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limitTo1(float val) {
        if (val < 0.0f) {
            return 0.0f;
        }
        if (val > 1.0f) {
            return 1.0f;
        }
        return val;
    }

    public static boolean isAnimatedWater() {
        return Config.gameSettings.ofAnimatedWater != 2;
    }

    public static boolean isGeneratedWater() {
        return Config.gameSettings.ofAnimatedWater == 1;
    }

    public static boolean isAnimatedPortal() {
        return Config.gameSettings.ofAnimatedPortal;
    }

    public static boolean isAnimatedLava() {
        return Config.gameSettings.ofAnimatedLava != 2;
    }

    public static boolean isGeneratedLava() {
        return Config.gameSettings.ofAnimatedLava == 1;
    }

    public static boolean isAnimatedFire() {
        return Config.gameSettings.ofAnimatedFire;
    }

    public static boolean isAnimatedRedstone() {
        return Config.gameSettings.ofAnimatedRedstone;
    }

    public static boolean isAnimatedExplosion() {
        return Config.gameSettings.ofAnimatedExplosion;
    }

    public static boolean isAnimatedFlame() {
        return Config.gameSettings.ofAnimatedFlame;
    }

    public static boolean isAnimatedSmoke() {
        return Config.gameSettings.ofAnimatedSmoke;
    }

    public static boolean isVoidParticles() {
        return Config.gameSettings.ofVoidParticles;
    }

    public static boolean isWaterParticles() {
        return Config.gameSettings.ofWaterParticles;
    }

    public static boolean isRainSplash() {
        return Config.gameSettings.ofRainSplash;
    }

    public static boolean isPortalParticles() {
        return Config.gameSettings.ofPortalParticles;
    }

    public static boolean isPotionParticles() {
        return Config.gameSettings.ofPotionParticles;
    }

    public static boolean isFireworkParticles() {
        return Config.gameSettings.ofFireworkParticles;
    }

    public static float getAmbientOcclusionLevel() {
        if (Config.isShaders() && Shaders.aoLevel >= 0.0f) {
            return Shaders.aoLevel;
        }
        return (float)Config.gameSettings.ofAoLevel;
    }

    public static String listToString(List list) {
        return Config.listToString(list, ", ");
    }

    public static String listToString(List list, String separator) {
        if (list == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(list.size() * 5);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object obj = list.get(i2);
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            int x2 = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x2));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr) {
        return Config.arrayToString(arr, ", ");
    }

    public static String arrayToString(float[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            float x2 = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x2));
        }
        return buf.toString();
    }

    public static dlx getMinecraft() {
        return minecraft;
    }

    public static elw getTextureManager() {
        return minecraft.L();
    }

    public static abc getResourceManager() {
        return minecraft.M();
    }

    public static InputStream getResourceStream(uh location) throws IOException {
        return Config.getResourceStream(minecraft.M(), location);
    }

    public static InputStream getResourceStream(abc resourceManager, uh location) throws IOException {
        abb res = resourceManager.a(location);
        if (res == null) {
            return null;
        }
        return res.b();
    }

    public static abb getResource(uh location) throws IOException {
        return minecraft.M().a(location);
    }

    public static boolean hasResource(uh location) {
        if (location == null) {
            return false;
        }
        aae rp = Config.getDefiningResourcePack(location);
        return rp != null;
    }

    public static boolean hasResource(abc resourceManager, uh location) {
        try {
            abb res = resourceManager.a(location);
            return res != null;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static boolean hasResource(aae rp, uh loc) {
        if (rp == null || loc == null) {
            return false;
        }
        return rp.b(aaf.a, loc);
    }

    public static aae[] getResourcePacks() {
        aar rep = minecraft.N();
        Collection packInfos = rep.e();
        ArrayList<aae> list = new ArrayList<aae>();
        for (eml rpic : packInfos) {
            aae rp = rpic.d();
            if (rp == Config.getDefaultResourcePack()) continue;
            list.add(rp);
        }
        aae[] rps = list.toArray(new aae[list.size()]);
        return rps;
    }

    public static String getResourcePackNames() {
        if (minecraft.M() == null) {
            return "";
        }
        aae[] rps = Config.getResourcePacks();
        if (rps.length <= 0) {
            return Config.getDefaultResourcePack().a();
        }
        Object[] names = new String[rps.length];
        for (int i2 = 0; i2 < rps.length; ++i2) {
            names[i2] = rps[i2].a();
        }
        String nameStr = Config.arrayToString(names);
        return nameStr;
    }

    public static aah getDefaultResourcePack() {
        return minecraft.O().a();
    }

    public static boolean isFromDefaultResourcePack(uh loc) {
        return Config.getDefiningResourcePack(loc) == Config.getDefaultResourcePack();
    }

    public static aae getDefiningResourcePack(uh location) {
        aar rep = minecraft.N();
        Collection packInfos = rep.e();
        List entries = (List)packInfos;
        for (int i2 = entries.size() - 1; i2 >= 0; --i2) {
            eml entry = (eml)entries.get(i2);
            aae rp = entry.d();
            if (!rp.b(aaf.a, location)) continue;
            return rp;
        }
        return null;
    }

    public static ebx getRenderGlobal() {
        return Config.minecraft.e;
    }

    public static ebs getGameRenderer() {
        return Config.minecraft.h;
    }

    public static boolean isBetterGrass() {
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static boolean isWeatherEnabled() {
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        return Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        return Config.gameSettings.ofSunMoon;
    }

    public static boolean isSunTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isSun();
    }

    public static boolean isMoonTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isMoon();
    }

    public static boolean isVignetteEnabled() {
        if (Config.isShaders() && !Shaders.isVignette()) {
            return false;
        }
        if (Config.gameSettings.ofVignette == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofVignette == 2;
    }

    public static boolean isStarsEnabled() {
        return Config.gameSettings.ofStars;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e2) {
            Config.error("", e2);
        }
    }

    public static boolean isTimeDayOnly() {
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeDefault() {
        return Config.gameSettings.ofTime == 0;
    }

    public static boolean isTimeNightOnly() {
        return Config.gameSettings.ofTime == 2;
    }

    public static int getAnisotropicFilterLevel() {
        return 1;
    }

    public static boolean isAnisotropicFiltering() {
        return Config.getAnisotropicFilterLevel() > 1;
    }

    public static int getAntialiasingLevel() {
        return 0;
    }

    public static boolean isAntialiasing() {
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean isAntialiasingConfigured() {
        return Config.getGameSettings().ofAaLevel > 0;
    }

    public static boolean isMultiTexture() {
        if (Config.getAnisotropicFilterLevel() > 1) {
            return true;
        }
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean between(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static boolean between(float val, float min, float max) {
        return val >= min && val <= max;
    }

    public static boolean isDrippingWaterLava() {
        return Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        return Config.gameSettings.ofBetterSnow;
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static float parseFloat(String str, float defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static boolean parseBoolean(String str, boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Boolean.parseBoolean(str);
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static Boolean parseBoolean(String str, Boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            if ((str = str.trim().toLowerCase()).equals("true")) {
                return Boolean.TRUE;
            }
            if (str.equals("false")) {
                return Boolean.FALSE;
            }
            return defVal;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        String[] strs = list.toArray(new String[list.size()]);
        return strs;
    }

    public static boolean isAnimatedTerrain() {
        return Config.gameSettings.ofAnimatedTerrain;
    }

    public static boolean isAnimatedTextures() {
        return Config.gameSettings.ofAnimatedTextures;
    }

    public static boolean isSwampColors() {
        return Config.gameSettings.ofSwampColors;
    }

    public static boolean isRandomEntities() {
        return Config.gameSettings.ofRandomEntities;
    }

    public static void checkGlError(String loc) {
        int errorCode = dgl.R();
        if (errorCode != 0 && GlErrors.isEnabled(errorCode)) {
            String errorText = Config.getGlErrorString(errorCode);
            String messageLog = String.format("OpenGL error: %s (%s), at: %s", errorCode, errorText, loc);
            Config.error(messageLog);
            if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlError", 10000L)) {
                String message = emq.a((String)"of.message.openglError", (Object[])new Object[]{errorCode, errorText});
                Config.minecraft.j.c().a((mr)new nd(message));
            }
        }
    }

    public static boolean isSmoothBiomes() {
        return Config.gameSettings.E > 0;
    }

    public static int getBiomeBlendRadius() {
        return Config.gameSettings.E;
    }

    public static boolean isCustomColors() {
        return Config.gameSettings.ofCustomColors;
    }

    public static boolean isCustomSky() {
        return Config.gameSettings.ofCustomSky;
    }

    public static boolean isCustomFonts() {
        return Config.gameSettings.ofCustomFonts;
    }

    public static boolean isShowCapes() {
        return Config.gameSettings.ofShowCapes;
    }

    public static boolean isConnectedTextures() {
        return Config.gameSettings.ofConnectedTextures != 3;
    }

    public static boolean isNaturalTextures() {
        return Config.gameSettings.ofNaturalTextures;
    }

    public static boolean isEmissiveTextures() {
        return Config.gameSettings.ofEmissiveTextures;
    }

    public static boolean isConnectedTexturesFancy() {
        return Config.gameSettings.ofConnectedTextures == 2;
    }

    public static boolean isFastRender() {
        return Config.gameSettings.ofFastRender;
    }

    public static boolean isTranslucentBlocksFancy() {
        if (Config.gameSettings.ofTranslucentBlocks == 0) {
            return Config.isGraphicsFancy();
        }
        return Config.gameSettings.ofTranslucentBlocks == 2;
    }

    public static boolean isShaders() {
        return Shaders.shaderPackLoaded;
    }

    public static String[] readLines(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return Config.readLines(fis);
    }

    public static String[] readLines(InputStream is) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }

    public static String readFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        return Config.readInputStream(fin, "ASCII");
    }

    public static String readInputStream(InputStream in) throws IOException {
        return Config.readInputStream(in, "ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(in, encoding);
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) >= 0) {
            baos.write(buf, 0, len);
        }
        is.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public static dmb getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String newRelease) {
        Config.newRelease = newRelease;
    }

    public static int compareRelease(String rel1, String rel2) {
        int rev2;
        String[] rels2;
        String branch2;
        String[] rels1 = Config.splitRelease(rel1);
        String branch1 = rels1[0];
        if (!branch1.equals(branch2 = (rels2 = Config.splitRelease(rel2))[0])) {
            return branch1.compareTo(branch2);
        }
        int rev1 = Config.parseInt(rels1[1], -1);
        if (rev1 != (rev2 = Config.parseInt(rels2[1], -1))) {
            return rev1 - rev2;
        }
        String suf1 = rels1[2];
        String suf2 = rels2[2];
        if (!suf1.equals(suf2)) {
            if (suf1.isEmpty()) {
                return 1;
            }
            if (suf2.isEmpty()) {
                return -1;
            }
        }
        return suf1.compareTo(suf2);
    }

    private static String[] splitRelease(String relStr) {
        if (relStr == null || relStr.length() <= 0) {
            return new String[]{"", "", ""};
        }
        Pattern p2 = Pattern.compile("([A-Z])([0-9]+)(.*)");
        Matcher m2 = p2.matcher(relStr);
        if (!m2.matches()) {
            return new String[]{"", "", ""};
        }
        String branch = Config.normalize(m2.group(1));
        String revision = Config.normalize(m2.group(2));
        String suffix = Config.normalize(m2.group(3));
        return new String[]{branch, revision, suffix};
    }

    public static int intHash(int x2) {
        x2 = x2 ^ 0x3D ^ x2 >> 16;
        x2 += x2 << 3;
        x2 ^= x2 >> 4;
        x2 *= 668265261;
        x2 ^= x2 >> 15;
        return x2;
    }

    public static int getRandom(fu blockPos, int face) {
        int rand = Config.intHash(face + 37);
        rand = Config.intHash(rand + blockPos.u());
        rand = Config.intHash(rand + blockPos.w());
        rand = Config.intHash(rand + blockPos.v());
        return rand;
    }

    public static int getAvailableProcessors() {
        return availableProcessors;
    }

    public static void updateAvailableProcessors() {
        availableProcessors = Runtime.getRuntime().availableProcessors();
    }

    public static boolean isSingleProcessor() {
        return Config.getAvailableProcessors() <= 1;
    }

    public static boolean isSmoothWorld() {
        return Config.gameSettings.ofSmoothWorld;
    }

    public static boolean isLazyChunkLoading() {
        return Config.gameSettings.ofLazyChunkLoading;
    }

    public static boolean isDynamicFov() {
        return Config.gameSettings.ofDynamicFov;
    }

    public static boolean isAlternateBlocks() {
        return Config.gameSettings.ofAlternateBlocks;
    }

    public static int getChunkViewDistance() {
        if (gameSettings == null) {
            return 10;
        }
        int chunkDistance = Config.gameSettings.b;
        return chunkDistance;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean equalsOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b2 = bs[i2];
            if (!Config.equals(a2, b2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(int val, int[] vals) {
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (vals[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b2 = bs[i2];
            if (a2 != b2) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    private static ByteBuffer readIconImage(InputStream is) throws IOException {
        BufferedImage var2 = ImageIO.read(is);
        int[] var3 = var2.getRGB(0, 0, var2.getWidth(), var2.getHeight(), null, 0, var2.getWidth());
        ByteBuffer var4 = ByteBuffer.allocate(4 * var3.length);
        int[] var5 = var3;
        int var6 = var3.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            int var8 = var5[var7];
            var4.putInt(var8 << 8 | var8 >> 24 & 0xFF);
        }
        var4.flip();
        return var4;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = arr.length;
        int newLen = arrLen + 1;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        newArr[arrLen] = obj;
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.add(index, obj);
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(newArr);
    }

    public static Object[] addObjectsToArray(Object[] arr, Object[] objs) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr;
        }
        int arrLen = arr.length;
        int newLen = arrLen + objs.length;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        System.arraycopy(objs, 0, newArr, arrLen, objs.length);
        return newArr;
    }

    public static Object[] removeObjectFromArray(Object[] arr, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.remove(obj);
        Object[] newArr = Config.collectionToArray(list, arr.getClass().getComponentType());
        return newArr;
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + elementClass);
        }
        Object[] array = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(array);
    }

    public static boolean isCustomItems() {
        return Config.gameSettings.ofCustomItems;
    }

    public static void drawFps(dhl matrixStackIn) {
        int fps = Reflector.getFieldValueInt(Reflector.Minecraft_debugFPS, -1);
        int fpsMin = Config.getFpsMin();
        int updates = Config.getChunkUpdates();
        int renderersActive = Config.minecraft.e.getCountActiveRenderers();
        int entities = Config.minecraft.e.getCountEntitiesRendered();
        int tileEntities = Config.minecraft.e.getCountTileEntitiesRendered();
        String fpsStr = "" + fps + "/" + fpsMin + " fps, C: " + renderersActive + ", E: " + entities + "+" + tileEntities + ", U: " + updates;
        Config.minecraft.g.b(matrixStackIn, fpsStr, 2.0f, 2.0f, -2039584);
    }

    public static int getFpsMin() {
        return fpsMinLast;
    }

    public static int getChunkUpdates() {
        return chunkUpdatesLast;
    }

    public static void updateFpsMin() {
        long timeAvgNs;
        int indexEnd;
        ads ft2 = minecraft.af();
        long[] frames = ft2.c();
        int index = ft2.b();
        if (index == (indexEnd = ft2.a())) {
            return;
        }
        int fps = Reflector.getFieldValueInt(Reflector.Minecraft_debugFPS, -1);
        if (fps <= 0) {
            fps = 1;
        }
        long timeMaxNs = timeAvgNs = (long)(1.0 / (double)fps * 1.0E9);
        long timeTotalNs = 0L;
        int ix = aec.b(index - 1, frames.length);
        while (ix != indexEnd && (double)timeTotalNs < 1.0E9) {
            long timeNs = frames[ix];
            if (timeNs > timeMaxNs) {
                timeMaxNs = timeNs;
            }
            timeTotalNs += timeNs;
            ix = aec.b(ix - 1, frames.length);
        }
        double timeMaxSec = (double)timeMaxNs / 1.0E9;
        fpsMinLast = (int)(1.0 / timeMaxSec);
    }

    private static void updateChunkUpdates() {
        chunkUpdatesLast = een.renderChunksUpdated;
        een.renderChunksUpdated = 0;
    }

    public static int getBitsOs() {
        String progFiles86 = System.getenv("ProgramFiles(X86)");
        if (progFiles86 != null) {
            return 64;
        }
        return 32;
    }

    public static int getBitsJre() {
        String[] propNames = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        for (int i2 = 0; i2 < propNames.length; ++i2) {
            String propName = propNames[i2];
            String propVal = System.getProperty(propName);
            if (propVal == null || !propVal.contains("64")) continue;
            return 64;
        }
        return 32;
    }

    public static boolean isNotify64BitJava() {
        return notify64BitJava;
    }

    public static void setNotify64BitJava(boolean flag) {
        notify64BitJava = flag;
    }

    public static boolean isConnectedModels() {
        return false;
    }

    public static void showGuiMessage(String line1, String line2) {
        GuiMessage gui = new GuiMessage(Config.minecraft.y, line1, line2);
        minecraft.a((dqs)gui);
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return Config.addIntsToArray(intArray, new int[]{intValue});
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray == null || copyFrom == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = intArray.length;
        int newLen = arrLen + copyFrom.length;
        int[] newArray = new int[newLen];
        System.arraycopy(intArray, 0, newArray, 0, arrLen);
        for (int index = 0; index < copyFrom.length; ++index) {
            newArray[index + arrLen] = copyFrom[index];
        }
        return newArray;
    }

    public static void writeFile(File file, String str) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = str.getBytes("ASCII");
        fos.write(bytes);
        fos.close();
    }

    public static void setTextureMap(elu textureMapTerrain) {
        Config.textureMapTerrain = textureMapTerrain;
    }

    public static elu getTextureMap() {
        return textureMapTerrain;
    }

    public static boolean isDynamicLights() {
        return Config.gameSettings.ofDynamicLights != 3;
    }

    public static boolean isDynamicLightsFast() {
        return Config.gameSettings.ofDynamicLights == 1;
    }

    public static boolean isDynamicHandLight() {
        if (!Config.isDynamicLights()) {
            return false;
        }
        if (Config.isShaders()) {
            return Shaders.isDynamicHandLight();
        }
        return true;
    }

    public static boolean isCustomEntityModels() {
        return Config.gameSettings.ofCustomEntityModels;
    }

    public static boolean isCustomGuis() {
        return Config.gameSettings.ofCustomGuis;
    }

    public static int getScreenshotSize() {
        return Config.gameSettings.ofScreenshotSize;
    }

    public static int[] toPrimitive(Integer[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new int[0];
        }
        int[] intArr = new int[arr.length];
        for (int i2 = 0; i2 < intArr.length; ++i2) {
            intArr[i2] = arr[i2];
        }
        return intArr;
    }

    public static boolean isRenderRegions() {
        return Config.gameSettings.ofRenderRegions && dgl.vboRegions;
    }

    public static boolean isVbo() {
        return GLX.useVbo();
    }

    public static boolean isSmoothFps() {
        return Config.gameSettings.ofSmoothFps;
    }

    public static boolean openWebLink(URI uri) {
        v.setExceptionOpenUrl(null);
        v.i().a(uri);
        Exception error = v.getExceptionOpenUrl();
        return error == null;
    }

    public static boolean isShowGlErrors() {
        return Config.gameSettings.ofShowGlErrors;
    }

    public static String arrayToString(boolean[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            boolean x2 = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x2));
        }
        return buf.toString();
    }

    public static boolean isIntegratedServerRunning() {
        if (minecraft.G() == null) {
            return false;
        }
        return minecraft.E();
    }

    public static IntBuffer createDirectIntBuffer(int capacity) {
        return dgp.a((int)(capacity << 2)).asIntBuffer();
    }

    public static String getGlErrorString(int err) {
        switch (err) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Invalid enum";
            }
            case 1281: {
                return "Invalid value";
            }
            case 1282: {
                return "Invalid operation";
            }
            case 1286: {
                return "Invalid framebuffer operation";
            }
            case 1285: {
                return "Out of memory";
            }
            case 1284: {
                return "Stack underflow";
            }
            case 1283: {
                return "Stack overflow";
            }
        }
        return "Unknown";
    }

    public static boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)minecraft.aB().i(), (int)key) == 1;
    }

    public static boolean isTrue(Boolean val) {
        return val != null && val != false;
    }

    public static boolean isReloadingResources() {
        dqf rlpg;
        if (Config.minecraft.z == null) {
            return false;
        }
        return !(Config.minecraft.z instanceof dqf) || !(rlpg = (dqf)Config.minecraft.z).isFadeOut();
    }

    public static boolean isQuadsToTriangles() {
        if (!Config.isShaders()) {
            return false;
        }
        return !Shaders.canRenderQuads();
    }

    public static void frameStart() {
        long timeNowMs = System.currentTimeMillis();
        long frameTimeMs = timeNowMs - timeLastFrameMs;
        timeLastFrameMs = timeNowMs;
        frameTimeMs = Config.limit(frameTimeMs, 1L, 1000L);
        averageFrameTimeMs = (averageFrameTimeMs + frameTimeMs) / 2L;
        averageFrameTimeMs = Config.limit(averageFrameTimeMs, 1L, 1000L);
        if (Config.minecraft.A != mcDebugLast) {
            mcDebugLast = Config.minecraft.A;
            Config.updateFpsMin();
            Config.updateChunkUpdates();
        }
    }

    public static long getAverageFrameTimeMs() {
        return averageFrameTimeMs;
    }

    public static float getAverageFrameTimeSec() {
        float frameTimeSec = (float)Config.getAverageFrameTimeMs() / 1000.0f;
        return frameTimeSec;
    }

    public static long getAverageFrameFps() {
        long frameFps = 1000L / Config.getAverageFrameTimeMs();
        return frameFps;
    }

    public static void checkNull(Object obj, String msg) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(msg);
        }
    }
}

