/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<uh, uh> textureLocations = null;
    private NbtTagValue nbtName = null;
    private bre[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bje[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bje[] COLORS_INVALID = new bje[0];
    private static final uh ANVIL_GUI_TEXTURE = new uh("textures/gui/container/anvil.png");
    private static final uh BEACON_GUI_TEXTURE = new uh("textures/gui/container/beacon.png");
    private static final uh BREWING_STAND_GUI_TEXTURE = new uh("textures/gui/container/brewing_stand.png");
    private static final uh CHEST_GUI_TEXTURE = new uh("textures/gui/container/generic_54.png");
    private static final uh CRAFTING_TABLE_GUI_TEXTURE = new uh("textures/gui/container/crafting_table.png");
    private static final uh HORSE_GUI_TEXTURE = new uh("textures/gui/container/horse.png");
    private static final uh DISPENSER_GUI_TEXTURE = new uh("textures/gui/container/dispenser.png");
    private static final uh ENCHANTMENT_TABLE_GUI_TEXTURE = new uh("textures/gui/container/enchanting_table.png");
    private static final uh FURNACE_GUI_TEXTURE = new uh("textures/gui/container/furnace.png");
    private static final uh HOPPER_GUI_TEXTURE = new uh("textures/gui/container/hopper.png");
    private static final uh INVENTORY_GUI_TEXTURE = new uh("textures/gui/container/inventory.png");
    private static final uh SHULKER_BOX_GUI_TEXTURE = new uh("textures/gui/container/shulker_box.png");
    private static final uh VILLAGER_GUI_TEXTURE = new uh("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bje[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        bje[] cols = new bje[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            bje col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i2] = col;
        }
        return cols;
    }

    private static bje parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bje[] colors = bje.values();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            bje enumDyeColor = colors[i2];
            if (enumDyeColor.a().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.c().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static uh parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new uh(basePath + "/" + tex);
    }

    private static Map<uh, uh> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<uh, uh> map = new HashMap<uh, uh>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            uh locKey = CustomGuiProperties.getGuiTextureLocation(container);
            uh locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            uh locKey = new uh(path);
            uh locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static uh getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, fu pos, bqd blockAccess) {
        bre biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.v(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, fu pos, bqd blockAccess, dqs screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, (bpe)blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, (bpe)blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, (bpe)blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, (bpe)blockAccess);
            }
        }
        return true;
    }

    public static String getName(dqs screen) {
        mr itc = screen.p();
        if (itc == null) {
            return null;
        }
        return itc.a();
    }

    private boolean matchesBeacon(fu pos, bpe blockAccess) {
        int l2;
        cdl te = blockAccess.c(pos);
        if (!(te instanceof cdg)) {
            return false;
        }
        cdg teb = (cdg)te;
        return this.levels == null || this.levels.isInRange(l2 = teb.h());
    }

    private boolean matchesChest(fu pos, bpe blockAccess) {
        cdl te = blockAccess.c(pos);
        if (te instanceof cdp) {
            cdp tec = (cdp)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof cdx) {
            cdx teec = (cdx)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(cdp tec, fu pos, bpe blockAccess) {
        cfj blockState = blockAccess.d_(pos);
        cgb chestType = blockState.b((cgl)bwh.c) ? (cgb)blockState.c((cgl)bwh.c) : cgb.a;
        boolean isLarge = chestType == cgb.a;
        boolean isTrapped = tec instanceof cep;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(cdx teec, fu pos, bpe blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(fu pos, bpe blockAccess) {
        EnumVariant var;
        cdl te = blockAccess.c(pos);
        if (!(te instanceof cdu)) {
            return false;
        }
        cdu ted = (cdu)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(cdu ted) {
        if (ted instanceof cdv) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(fu pos, bpe blockAccess) {
        bje col;
        cdl te = blockAccess.c(pos);
        if (!(te instanceof ceg)) {
            return false;
        }
        ceg tesb = (ceg)te;
        return this.colors == null || Config.equalsOne(col = tesb.k(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, aom entity, bqd blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.cA(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.bT())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, (bpe)blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, (bpe)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(aom entity, bpe blockAccess) {
        int level;
        bdq vd;
        bds vp;
        if (!(entity instanceof bdp)) {
            return false;
        }
        bdp entityVillager = (bdp)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.eY()).b(), level = vd.c(), this.professions);
    }

    private boolean matchesHorse(aom entity, bpe blockAccess) {
        azp el;
        bje col;
        EnumVariant var;
        if (!(entity instanceof azm)) {
            return false;
        }
        azm ah = (azm)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof azp) || Config.equalsOne(col = (el = (azp)ah).fz(), this.colors);
    }

    private EnumVariant getHorseVariant(azm entity) {
        if (entity instanceof azo) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof azn) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof azr) {
            return EnumVariant.MULE;
        }
        if (entity instanceof azp) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public uh getTextureLocation(uh loc) {
        uh locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

