/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static final String SUFFIX_PNG = ".png";
    private static final uh LOCATION_TEXTURE_EMPTY = TextureUtils.LOCATION_TEXTURE_EMPTY;
    private static final uh LOCATION_SPRITE_EMPTY = TextureUtils.LOCATION_SPRITE_EMPTY;
    private static elw textureManager;
    private static int countRecursive;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        if (render) {
            ++countRecursive;
            return;
        }
        render = true;
        hasEmissive = false;
    }

    public static uh getEmissiveTexture(uh locationIn) {
        if (!render) {
            return locationIn;
        }
        elj texture = textureManager.b(locationIn);
        uh locationEmissive = null;
        if (texture instanceof elr) {
            locationEmissive = ((elr)texture).locationEmissive;
        }
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return locationIn;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_TEXTURE_EMPTY;
        }
        return locationEmissive;
    }

    public static elv getEmissiveSprite(elv sprite) {
        if (!render) {
            return sprite;
        }
        elv spriteEmissive = sprite.spriteEmissive;
        if (!renderEmissive) {
            if (spriteEmissive != null) {
                hasEmissive = true;
            }
            return sprite;
        }
        if (spriteEmissive == null) {
            spriteEmissive = sprite.m().a(LOCATION_SPRITE_EMPTY);
        }
        return spriteEmissive;
    }

    public static ect getEmissiveQuad(ect quad) {
        if (!render) {
            return quad;
        }
        ect quadEmissive = quad.getQuadEmissive();
        if (!renderEmissive) {
            if (quadEmissive != null) {
                hasEmissive = true;
            }
            return quad;
        }
        return quadEmissive;
    }

    public static boolean hasEmissive() {
        if (countRecursive > 0) {
            return false;
        }
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = true;
    }

    public static boolean isRenderEmissive() {
        return renderEmissive;
    }

    public static void endRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = false;
    }

    public static void endRender() {
        if (countRecursive > 0) {
            --countRecursive;
            return;
        }
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        textureManager = dlx.B().L();
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            uh loc = new uh(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void updateIcons(elu textureMap, Set<uh> locations) {
        if (!active) {
            return;
        }
        for (uh loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(elu textureMap, uh locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.a().endsWith(suffixEm)) {
            return;
        }
        uh locSpriteEm = new uh(locSprite.b(), locSprite.a() + suffixEm);
        uh locPngEm = textureMap.b(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        elv sprite = textureMap.registerSprite(locSprite);
        elv spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void refreshIcons(elu textureMap) {
        Collection<elv> sprites = textureMap.getRegisteredSprites();
        for (elv sprite : sprites) {
            EmissiveTextures.refreshIcon(sprite, textureMap);
        }
    }

    private static void refreshIcon(elv sprite, elu textureMap) {
        if (sprite.spriteEmissive == null) {
            return;
        }
        elv spriteNew = textureMap.getUploadedSprite(sprite.l());
        if (spriteNew == null) {
            return;
        }
        elv spriteEmissiveNew = textureMap.getUploadedSprite(sprite.spriteEmissive.l());
        if (spriteEmissiveNew == null) {
            return;
        }
        spriteEmissiveNew.isSpriteEmissive = true;
        spriteNew.spriteEmissive = spriteEmissiveNew;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(uh loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.a().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(uh loc, elr tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.a();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        uh locEmPng = new uh(loc.b(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        countRecursive = 0;
    }
}

