/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.IdentityHashMap;
import java.util.Map;
import net.optifine.Config;

public class NaturalProperties {
    public int rotation = 1;
    public boolean flip = false;
    private Map[] quadMaps = new Map[8];

    public NaturalProperties(String type) {
        if (type.equals("4")) {
            this.rotation = 4;
            return;
        }
        if (type.equals("2")) {
            this.rotation = 2;
            return;
        }
        if (type.equals("F")) {
            this.flip = true;
            return;
        }
        if (type.equals("4F")) {
            this.rotation = 4;
            this.flip = true;
            return;
        }
        if (type.equals("2F")) {
            this.rotation = 2;
            this.flip = true;
            return;
        }
        Config.warn("NaturalTextures: Unknown type: " + type);
    }

    public boolean isValid() {
        if (this.rotation == 2 || this.rotation == 4) {
            return true;
        }
        return this.flip;
    }

    public synchronized ect getQuad(ect quadIn, int rotate, boolean flipU) {
        ect quad;
        int index = rotate;
        if (flipU) {
            index |= 4;
        }
        if (index <= 0 || index >= this.quadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<ect, ect> map = this.quadMaps[index];
        if (map == null) {
            this.quadMaps[index] = map = new IdentityHashMap<ect, ect>(1);
        }
        if ((quad = (ect)map.get(quadIn)) == null) {
            quad = this.makeQuad(quadIn, rotate, flipU);
            map.put(quadIn, quad);
        }
        return quad;
    }

    private ect makeQuad(ect quad, int rotate, boolean flipU) {
        int[] vertexData = quad.b();
        int tintIndex = quad.d();
        fz face = quad.e();
        elv sprite = quad.getSprite();
        boolean shade = quad.f();
        if (!this.isFullSprite(quad)) {
            rotate = 0;
        }
        vertexData = this.transformVertexData(vertexData, rotate, flipU);
        ect bq = new ect(vertexData, tintIndex, face, sprite, shade);
        return bq;
    }

    private int[] transformVertexData(int[] vertexData, int rotate, boolean flipU) {
        int[] vertexData2 = (int[])vertexData.clone();
        int v2 = 4 - rotate;
        if (flipU) {
            v2 += 3;
        }
        v2 %= 4;
        int step = vertexData2.length / 4;
        for (int v3 = 0; v3 < 4; ++v3) {
            int pos = v3 * step;
            int pos2 = v2 * step;
            vertexData2[pos2 + 4] = vertexData[pos + 4];
            vertexData2[pos2 + 4 + 1] = vertexData[pos + 4 + 1];
            if (flipU) {
                if (--v2 >= 0) continue;
                v2 = 3;
                continue;
            }
            if (++v2 <= 3) continue;
            v2 = 0;
        }
        return vertexData2;
    }

    private boolean isFullSprite(ect quad) {
        elv sprite = quad.getSprite();
        float uMin = sprite.h();
        float uMax = sprite.i();
        float uSize = uMax - uMin;
        float uDelta = uSize / 256.0f;
        float vMin = sprite.j();
        float vMax = sprite.k();
        float vSize = vMax - vMin;
        float vDelta = vSize / 256.0f;
        int[] vertexData = quad.b();
        int step = vertexData.length / 4;
        for (int i2 = 0; i2 < 4; ++i2) {
            int pos = i2 * step;
            float u2 = Float.intBitsToFloat(vertexData[pos + 4]);
            float v2 = Float.intBitsToFloat(vertexData[pos + 4 + 1]);
            if (!this.equalsDelta(u2, uMin, uDelta) && !this.equalsDelta(u2, uMax, uDelta)) {
                return false;
            }
            if (this.equalsDelta(v2, vMin, vDelta) || this.equalsDelta(v2, vMax, vDelta)) continue;
            return false;
        }
        return true;
    }

    private boolean equalsDelta(float x1, float x2, float deltaMax) {
        float deltaAbs = aec.e(x1 - x2);
        return deltaAbs < deltaMax;
    }
}

