/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.util.Either;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<aoq, egn> originalEntityRenderMap = null;
    private static Map<cdm, edx> originalTileEntityRenderMap = null;
    private static Map<cay.a, dwo> originalSkullModelMap = null;

    public static void update() {
        Map<aoq, egn> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<cdm, edx> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map<cay.a, dwo> skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        if (!Config.isCustomEntityModels()) {
            return;
        }
        uh[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            uh loc = locs[i2];
            Config.dbg("CustomEntityModel: " + loc.a());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null) continue;
            Either<aoq, cdm> type = rc.getType();
            if (rc instanceof egn) {
                entityRenderMap.put(type.getLeft().get(), (egn)rc);
            } else if (rc instanceof edx) {
                tileEntityRenderMap.put(type.getRight().get(), (edx)rc);
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static Map<aoq, egn> getEntityRenderMap() {
        egm rm = dlx.B().ab();
        Map<aoq, egn> entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<aoq, egn>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<cdm, edx> getTileEntityRenderMap() {
        Map<cdm, edx> tileEntityRenderMap = edw.a.f;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<cdm, edx>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<cay.a, dwo> getSkullModelMap() {
        HashMap skullModelMap = (HashMap)Reflector.TileEntitySkullRenderer_MODELS.getValue();
        if (skullModelMap == null) {
            Config.warn("Field not found: TileEntitySkullRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap<cay.a, dwo>(skullModelMap);
        }
        return skullModelMap;
    }

    private static uh[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<uh> resourceLocations = new ArrayList<uh>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            uh loc = new uh(path);
            if (!Config.hasResource(loc)) continue;
            resourceLocations.add(loc);
        }
        uh[] locs = resourceLocations.toArray(new uh[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(uh location) {
        try {
            JsonObject jo = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo, location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
        catch (JsonParseException e3) {
            Config.error("" + ((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage());
            return null;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Either<aoq, cdm> type = modelAdapter.getType();
        CustomEntityModels.checkNull(type, "Entity type not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        dwo model;
        uh textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr2 = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr2)) {
            return null;
        }
        IEntityRenderer r2 = modelAdapter.makeEntityRender(model, shadowSize);
        if (r2 == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            r2.setLocationTextureCustom(textureLocation);
        }
        return r2;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dwo model, CustomModelRenderer[] modelRenderers, ModelResolver mr2) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr2)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dwo model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        dyg parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                dyg[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                ObjectList<dyg> childModels = parent.n;
                Iterator it = childModels.iterator();
                while (it.hasNext()) {
                    dyg mr2 = (dyg)it.next();
                    if (setMrs.contains(mr2)) continue;
                    it.remove();
                }
            }
        }
        parent.b(customModelRenderer.getModelRenderer());
        ModelUpdater mu2 = customModelRenderer.getModelUpdater();
        if (mu2 != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu2.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu2);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

