/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<aoq, cdm> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(aoq entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(aoq entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cdm tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(Either<aoq, cdm> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<aoq, cdm> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract dwo makeModel();

    public abstract dyg getModelRenderer(dwo var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(dwo var1, float var2);

    public dyg[] getModelRenderers(dwo model) {
        String[] names = this.getModelRendererNames();
        ArrayList<dyg> list = new ArrayList<dyg>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            dyg mr2 = this.getModelRenderer(model, name);
            if (mr2 == null) continue;
            list.add(mr2);
        }
        dyg[] mrs = list.toArray(new dyg[list.size()]);
        return mrs;
    }
}

