/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.Config;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableFloat;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.expr.IExpression;
import net.optifine.util.Either;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private dwo model;
    private CustomModelRenderer[] customModelRenderers;
    private dyg thisModelRenderer;
    private dyg partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, dwo model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Either<aoq, cdm> type = modelAdapter.getType();
        this.renderResolver = type.getRight().isPresent() ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariableFloat mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression param = this.renderResolver.getParameter(name);
        if (param != null) {
            return param;
        }
        return null;
    }

    @Override
    public dyg getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize(name, ":");
            dyg mr2 = this.getModelRenderer(parts[0]);
            for (int i2 = 1; i2 < parts.length; ++i2) {
                String part = parts[i2];
                dyg mrSub = mr2.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr2 = mrSub;
            }
            return mr2;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        dyg mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i3 = 0; i3 < this.customModelRenderers.length; ++i3) {
            CustomModelRenderer cmr = this.customModelRenderers[i3];
            dyg mr3 = cmr.getModelRenderer();
            if (name.equals(mr3.getId())) {
                return mr3;
            }
            dyg mrChild = mr3.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    @Override
    public ModelVariableFloat getModelVariable(String name) {
        String[] parts = Config.tokenize(name, ".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        dyg mr2 = this.getModelRenderer(modelName);
        if (mr2 == null) {
            return null;
        }
        ModelVariableType varType = ModelVariableType.parse(varName);
        if (varType == null) {
            return null;
        }
        return new ModelVariableFloat(name, mr2, varType);
    }

    public void setPartModelRenderer(dyg partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(dyg thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

