/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final fz[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays(false);
    public static final fz[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays(true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static bqb worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(bqb world, aom viewEntity, int renderDistanceChunks) {
        int pcx = aec.c(viewEntity.cC()) >> 4;
        int pcy = aec.c(viewEntity.cD()) >> 4;
        int pcz = aec.c(viewEntity.cG()) >> 4;
        pcy = Config.limit(pcy, 0, 15);
        chj playerChunk = world.d(pcx, pcz);
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            block9: for (int cz = czStart; cz < czEnd; ++cz) {
                chj chunk = world.d(cx, cz);
                if (chunk.t()) continue;
                chk[] ebss = chunk.d();
                for (int i2 = ebss.length - 1; i2 > iMax; --i2) {
                    chk ebs2 = ebss[i2];
                    if (ebs2 == null || ebs2.c()) continue;
                    if (i2 <= iMax) break;
                    iMax = i2;
                    break;
                }
                try {
                    Map mapTileEntities = chunk.y();
                    if (!mapTileEntities.isEmpty()) {
                        Set keys = mapTileEntities.keySet();
                        for (fu pos : keys) {
                            int i3 = pos.v() >> 4;
                            if (i3 <= iMax) continue;
                            iMax = i3;
                        }
                    }
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
                adk[] cimms = chunk.z();
                for (int i4 = cimms.length - 1; i4 > iMax; --i4) {
                    adk cimm = cimms[i4];
                    if (cimm.isEmpty() || chunk == playerChunk && i4 == pcy && cimm.size() == 1) continue;
                    if (i4 <= iMax) continue block9;
                    iMax = i4;
                    continue block9;
                }
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return iMax << 4;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static fz[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        fz[][] arrs = new fz[count][];
        for (int i2 = 0; i2 < count; ++i2) {
            ArrayList<fz> list = new ArrayList<fz>();
            for (int ix = 0; ix < fz.n.length; ++ix) {
                fz facing = fz.n[ix];
                fz facingMask = opposite ? facing.f() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i2 & mask) == 0) continue;
                list.add(facing);
            }
            fz[] fs = list.toArray(new fz[list.size()]);
            arrs[i2] = fs;
        }
        return arrs;
    }

    public static fz[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

