/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import net.optifine.util.TextureUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ShadersTex {
    public static final int initialBufferSize = 0x100000;
    public static ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)0x400000);
    public static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    public static int[] intArray = new int[0x100000];
    public static final int defBaseTexColor = 0;
    public static final int defNormTexColor = -8421377;
    public static final int defSpecTexColor = 0;
    public static Map<Integer, MultiTexID> multiTexMap = new HashMap<Integer, MultiTexID>();

    public static IntBuffer getIntBuffer(int size) {
        if (intBuffer.capacity() < size) {
            int bufferSize = ShadersTex.roundUpPOT(size);
            byteBuffer = BufferUtils.createByteBuffer((int)(bufferSize * 4));
            intBuffer = byteBuffer.asIntBuffer();
        }
        return intBuffer;
    }

    public static int[] getIntArray(int size) {
        if (intArray == null) {
            intArray = new int[0x100000];
        }
        if (intArray.length < size) {
            intArray = new int[ShadersTex.roundUpPOT(size)];
        }
        return intArray;
    }

    public static int roundUpPOT(int x2) {
        int i2 = x2 - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public static int log2(int x2) {
        int log = 0;
        if ((x2 & 0xFFFF0000) != 0) {
            log += 16;
            x2 >>= 16;
        }
        if ((x2 & 0xFF00) != 0) {
            log += 8;
            x2 >>= 8;
        }
        if ((x2 & 0xF0) != 0) {
            log += 4;
            x2 >>= 4;
        }
        if ((x2 & 6) != 0) {
            log += 2;
            x2 >>= 2;
        }
        if ((x2 & 2) != 0) {
            ++log;
        }
        return log;
    }

    public static IntBuffer fillIntBuffer(int size, int value) {
        int[] aint = ShadersTex.getIntArray(size);
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        Arrays.fill(intArray, 0, size, value);
        intBuffer.put(intArray, 0, size);
        return intBuffer;
    }

    public static int[] createAIntImage(int size) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, 0);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static int[] createAIntImage(int size, int color) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, color);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static MultiTexID getMultiTexID(elj tex) {
        MultiTexID multiTex = tex.multiTex;
        if (multiTex == null) {
            int baseTex = tex.b();
            multiTex = multiTexMap.get(baseTex);
            if (multiTex == null) {
                multiTex = new MultiTexID(baseTex, GL11.glGenTextures(), GL11.glGenTextures());
                multiTexMap.put(baseTex, multiTex);
            }
            tex.multiTex = multiTex;
        }
        return multiTex;
    }

    public static void deleteTextures(elj atex, int texid) {
        MultiTexID multiTex = atex.multiTex;
        if (multiTex != null) {
            atex.multiTex = null;
            multiTexMap.remove(multiTex.base);
            dgl.r(multiTex.norm);
            dgl.r(multiTex.spec);
            if (multiTex.base != texid) {
                SMCLog.warning("Error : MultiTexID.base mismatch: " + multiTex.base + ", texid: " + texid);
                dgl.r(multiTex.base);
            }
        }
    }

    public static void bindNSTextures(int normTex, int specTex) {
        if (Shaders.isRenderingWorld && dgl.getActiveTextureUnit() == 33984) {
            dgl.q(33985);
            dgl.s(normTex);
            dgl.q(33987);
            dgl.s(specTex);
            dgl.q(33984);
        }
    }

    public static void bindNSTextures(MultiTexID multiTex) {
        ShadersTex.bindNSTextures(multiTex.norm, multiTex.spec);
    }

    public static void bindTextures(int baseTex, int normTex, int specTex) {
        if (Shaders.isRenderingWorld && dgl.getActiveTextureUnit() == 33984) {
            dgl.q(33985);
            dgl.s(normTex);
            dgl.q(33987);
            dgl.s(specTex);
            dgl.q(33984);
        }
        dgl.s(baseTex);
    }

    public static void bindTextures(MultiTexID multiTex) {
        if (Shaders.isRenderingWorld && dgl.getActiveTextureUnit() == 33984) {
            if (Shaders.configNormalMap) {
                dgl.q(33985);
                dgl.s(multiTex.norm);
            }
            if (Shaders.configSpecularMap) {
                dgl.q(33987);
                dgl.s(multiTex.spec);
            }
            dgl.q(33984);
        }
        dgl.s(multiTex.base);
    }

    public static void bindTexture(elj tex) {
        int texId = tex.b();
        ShadersTex.bindTextures(tex.getMultiTexID());
        if (dgl.getActiveTextureUnit() == 33984) {
            int prevSizeX = Shaders.atlasSizeX;
            int prevSizeY = Shaders.atlasSizeY;
            if (tex instanceof elu) {
                Shaders.atlasSizeX = ((elu)tex).atlasWidth;
                Shaders.atlasSizeY = ((elu)tex).atlasHeight;
            } else {
                Shaders.atlasSizeX = 0;
                Shaders.atlasSizeY = 0;
            }
            if (Shaders.atlasSizeX != prevSizeX || Shaders.atlasSizeY != prevSizeY) {
                boolean oldFlush = RenderUtils.setFlushRenderBuffers(false);
                Shaders.uniform_atlasSize.setValue(Shaders.atlasSizeX, Shaders.atlasSizeY);
                RenderUtils.setFlushRenderBuffers(oldFlush);
            }
        }
    }

    public static void bindTextures(int baseTex) {
        MultiTexID multiTex = multiTexMap.get(baseTex);
        ShadersTex.bindTextures(multiTex);
    }

    public static void initDynamicTextureNS(ell tex) {
        MultiTexID multiTex = tex.getMultiTexID();
        dgs nativeImage = tex.e();
        int width = nativeImage.a();
        int height = nativeImage.b();
        dgs imageNormal = ShadersTex.makeImageColor(width, height, -8421377);
        dgw.a((int)multiTex.norm, (int)width, (int)height);
        imageNormal.a(0, 0, 0, 0, 0, width, height, false, false, false, true);
        dgs imageSpecular = ShadersTex.makeImageColor(width, height, 0);
        dgw.a((int)multiTex.spec, (int)width, (int)height);
        imageSpecular.a(0, 0, 0, 0, 0, width, height, false, false, false, true);
        dgl.s(multiTex.base);
    }

    public static void updateDynTexSubImage1(int[] src, int width, int height, int posX, int posY, int page) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        intBuf.clear();
        int offset = page * size;
        if (src.length < offset + size) {
            return;
        }
        intBuf.put(src, offset, size).position(0).limit(size);
        TextureUtils.resetDataUnpacking();
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        intBuf.clear();
    }

    public static elj createDefaultTexture() {
        ell tex = new ell(1, 1, true);
        tex.e().a(0, 0, -1);
        tex.a();
        return tex;
    }

    public static void allocateTextureMapNS(int mipmapLevels, int width, int height, elu tex) {
        MultiTexID multiTex = ShadersTex.getMultiTexID(tex);
        if (Shaders.configNormalMap) {
            SMCLog.info("Allocate texture map normal: " + width + "x" + height + ", mipmaps: " + mipmapLevels);
            dgw.a((int)multiTex.norm, (int)mipmapLevels, (int)width, (int)height);
        }
        if (Shaders.configSpecularMap) {
            SMCLog.info("Allocate texture map specular: " + width + "x" + height + ", mipmaps: " + mipmapLevels);
            dgw.a((int)multiTex.spec, (int)mipmapLevels, (int)width, (int)height);
        }
        dgl.s(multiTex.base);
    }

    private static dgs[] generateMipmaps(dgs image, int levels) {
        if (levels < 0) {
            levels = 0;
        }
        dgs[] mipmapImages = new dgs[levels + 1];
        mipmapImages[0] = image;
        if (levels > 0) {
            for (int level = 1; level <= levels; ++level) {
                dgs imageParent = mipmapImages[level - 1];
                dgs imageChild = new dgs(imageParent.a() >> 1, imageParent.b() >> 1, false);
                int k2 = imageChild.a();
                int l2 = imageChild.b();
                for (int x2 = 0; x2 < k2; ++x2) {
                    for (int y = 0; y < l2; ++y) {
                        imageChild.a(x2, y, ShadersTex.blend4Simple(imageParent.a(x2 * 2 + 0, y * 2 + 0), imageParent.a(x2 * 2 + 1, y * 2 + 0), imageParent.a(x2 * 2 + 0, y * 2 + 1), imageParent.a(x2 * 2 + 1, y * 2 + 1)));
                    }
                }
                mipmapImages[level] = imageChild;
            }
        }
        return mipmapImages;
    }

    public static BufferedImage readImage(uh resLoc) {
        try {
            if (!Config.hasResource(resLoc)) {
                return null;
            }
            InputStream istr = Config.getResourceStream(resLoc);
            if (istr == null) {
                return null;
            }
            BufferedImage image = ImageIO.read(istr);
            istr.close();
            return image;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static int[][] genMipmapsSimple(int maxLevel, int width, int[][] data) {
        for (int level = 1; level <= maxLevel; ++level) {
            if (data[level] != null) continue;
            int cw = width >> level;
            int pw = cw * 2;
            int[] aintp = data[level - 1];
            data[level] = new int[cw * cw];
            int[] aintc = data[level];
            for (int y = 0; y < cw; ++y) {
                for (int x2 = 0; x2 < cw; ++x2) {
                    int ppos = y * 2 * pw + x2 * 2;
                    aintc[y * cw + x2] = ShadersTex.blend4Simple(aintp[ppos], aintp[ppos + 1], aintp[ppos + pw], aintp[ppos + pw + 1]);
                }
            }
        }
        return data;
    }

    public static void uploadTexSub1(int[][] src, int width, int height, int posX, int posY, int page) {
        TextureUtils.resetDataUnpacking();
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        int numLevel = src.length;
        int level = 0;
        int lw = width;
        int lh2 = height;
        int px = posX;
        int py = posY;
        while (lw > 0 && lh2 > 0 && level < numLevel) {
            int lsize = lw * lh2;
            int[] aint = src[level];
            intBuf.clear();
            if (aint.length >= lsize * (page + 1)) {
                intBuf.put(aint, lsize * page, lsize).position(0).limit(lsize);
                GL11.glTexSubImage2D((int)3553, (int)level, (int)px, (int)py, (int)lw, (int)lh2, (int)32993, (int)33639, (IntBuffer)intBuf);
            }
            lw >>= 1;
            lh2 >>= 1;
            px >>= 1;
            py >>= 1;
            ++level;
        }
        intBuf.clear();
    }

    public static int blend4Alpha(int c0, int c1, int c2, int c3) {
        int dv;
        int a0 = c0 >>> 24 & 0xFF;
        int a1 = c1 >>> 24 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int a3 = c3 >>> 24 & 0xFF;
        int as = a0 + a1 + a2 + a3;
        int an = (as + 2) / 4;
        if (as != 0) {
            dv = as;
        } else {
            dv = 4;
            a0 = 1;
            a1 = 1;
            a2 = 1;
            a3 = 1;
        }
        int frac = (dv + 1) / 2;
        int color = an << 24 | ((c0 >>> 16 & 0xFF) * a0 + (c1 >>> 16 & 0xFF) * a1 + (c2 >>> 16 & 0xFF) * a2 + (c3 >>> 16 & 0xFF) * a3 + frac) / dv << 16 | ((c0 >>> 8 & 0xFF) * a0 + (c1 >>> 8 & 0xFF) * a1 + (c2 >>> 8 & 0xFF) * a2 + (c3 >>> 8 & 0xFF) * a3 + frac) / dv << 8 | ((c0 >>> 0 & 0xFF) * a0 + (c1 >>> 0 & 0xFF) * a1 + (c2 >>> 0 & 0xFF) * a2 + (c3 >>> 0 & 0xFF) * a3 + frac) / dv << 0;
        return color;
    }

    public static int blend4Simple(int c0, int c1, int c2, int c3) {
        int color = ((c0 >>> 24 & 0xFF) + (c1 >>> 24 & 0xFF) + (c2 >>> 24 & 0xFF) + (c3 >>> 24 & 0xFF) + 2) / 4 << 24 | ((c0 >>> 16 & 0xFF) + (c1 >>> 16 & 0xFF) + (c2 >>> 16 & 0xFF) + (c3 >>> 16 & 0xFF) + 2) / 4 << 16 | ((c0 >>> 8 & 0xFF) + (c1 >>> 8 & 0xFF) + (c2 >>> 8 & 0xFF) + (c3 >>> 8 & 0xFF) + 2) / 4 << 8 | ((c0 >>> 0 & 0xFF) + (c1 >>> 0 & 0xFF) + (c2 >>> 0 & 0xFF) + (c3 >>> 0 & 0xFF) + 2) / 4 << 0;
        return color;
    }

    public static void genMipmapAlpha(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x2 = 0; x2 < w1; ++x2) {
                    aint[p1 + x2] = ShadersTex.blend4Alpha(aint[p2 + x2 * 2], aint[p2 + (x2 * 2 + 1)], aint[p2 + w2 + x2 * 2], aint[p2 + w2 + (x2 * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x3 = 0; x3 < w2; ++x3) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x3 / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static void genMipmapSimple(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x2 = 0; x2 < w1; ++x2) {
                    aint[p1 + x2] = ShadersTex.blend4Simple(aint[p2 + x2 * 2], aint[p2 + (x2 * 2 + 1)], aint[p2 + w2 + x2 * 2], aint[p2 + w2 + (x2 * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x3 = 0; x3 < w2; ++x3) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x3 / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static boolean isSemiTransparent(int[] aint, int width, int height) {
        int size = width * height;
        if (aint[0] >>> 24 == 255 && aint[size - 1] == 0) {
            return true;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            int alpha = aint[i2] >>> 24;
            if (alpha == 0 || alpha == 255) continue;
            return true;
        }
        return false;
    }

    public static void updateSubTex1(int[] src, int width, int height, int posX, int posY) {
        int level = 0;
        int cw = width;
        int ch = height;
        int cx = posX;
        int cy = posY;
        while (cw > 0 && ch > 0) {
            GL11.glCopyTexSubImage2D((int)3553, (int)level, (int)cx, (int)cy, (int)0, (int)0, (int)cw, (int)ch);
            ++level;
            cw /= 2;
            ch /= 2;
            cx /= 2;
            cy /= 2;
        }
    }

    public static void updateSubImage(MultiTexID multiTex, int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        TextureUtils.resetDataUnpacking();
        intBuf.clear();
        intBuf.put(src, 0, size);
        intBuf.position(0).limit(size);
        dgl.s(multiTex.base);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size, size).position(0);
            intBuf.position(0).limit(size);
        }
        dgl.s(multiTex.norm);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size * 2, size);
            intBuf.position(0).limit(size);
        }
        dgl.s(multiTex.spec);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        dgl.q(33984);
    }

    public static uh getNSMapLocation(uh location, String mapName) {
        if (location == null) {
            return null;
        }
        String basename = location.a();
        String[] basenameParts = basename.split(".png");
        String basenameNoFileType = basenameParts[0];
        return new uh(location.b(), basenameNoFileType + "_" + mapName + ".png");
    }

    private static dgs loadNSMapImage(abc manager, uh location, int width, int height, int defaultColor) {
        dgs image = ShadersTex.loadNSMapFile(manager, location, width, height);
        if (image == null) {
            image = new dgs(width, height, false);
            int colAbgr = TextureUtils.toAbgr(defaultColor);
            image.a(0, 0, width, height, colAbgr);
        }
        return image;
    }

    private static dgs makeImageColor(int width, int height, int defaultColor) {
        dgs image = new dgs(width, height, false);
        int colAbgr = TextureUtils.toAbgr(defaultColor);
        image.fillRGBA(colAbgr);
        return image;
    }

    private static dgs loadNSMapFile(abc manager, uh location, int width, int height) {
        if (location == null) {
            return null;
        }
        try {
            abb res = manager.a(location);
            dgs image = dgs.a(res.b());
            if (image == null) {
                return null;
            }
            if (image.a() != width || image.b() != height) {
                image.close();
                return null;
            }
            return image;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void loadSimpleTextureNS(int textureID, dgs nativeImage, boolean blur, boolean clamp, abc resourceManager, uh location, MultiTexID multiTex) {
        int width = nativeImage.a();
        int height = nativeImage.b();
        uh locNormal = ShadersTex.getNSMapLocation(location, "n");
        dgs imageNormal = ShadersTex.loadNSMapImage(resourceManager, locNormal, width, height, -8421377);
        dgw.a((int)multiTex.norm, (int)0, (int)width, (int)height);
        imageNormal.a(0, 0, 0, 0, 0, width, height, blur, clamp, false, true);
        uh locSpecular = ShadersTex.getNSMapLocation(location, "s");
        dgs imageSpecular = ShadersTex.loadNSMapImage(resourceManager, locSpecular, width, height, 0);
        dgw.a((int)multiTex.spec, (int)0, (int)width, (int)height);
        imageSpecular.a(0, 0, 0, 0, 0, width, height, blur, clamp, false, true);
        dgl.s(multiTex.base);
    }

    public static void mergeImage(int[] aint, int dstoff, int srcoff, int size) {
    }

    public static int blendColor(int color1, int color2, int factor1) {
        int factor2 = 255 - factor1;
        return ((color1 >>> 24 & 0xFF) * factor1 + (color2 >>> 24 & 0xFF) * factor2) / 255 << 24 | ((color1 >>> 16 & 0xFF) * factor1 + (color2 >>> 16 & 0xFF) * factor2) / 255 << 16 | ((color1 >>> 8 & 0xFF) * factor1 + (color2 >>> 8 & 0xFF) * factor2) / 255 << 8 | ((color1 >>> 0 & 0xFF) * factor1 + (color2 >>> 0 & 0xFF) * factor2) / 255 << 0;
    }

    public static void updateTextureMinMagFilter() {
        elw texman = dlx.B().L();
        elj texObj = texman.b(elu.d);
        if (texObj != null) {
            MultiTexID multiTex = texObj.getMultiTexID();
            dgl.s(multiTex.base);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
            dgl.s(multiTex.norm);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
            dgl.s(multiTex.spec);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
            dgl.s(0);
        }
    }

    public static int[][] getFrameTexData(int[][] src, int width, int height, int frameIndex) {
        int numLevel = src.length;
        int[][] dst = new int[numLevel][];
        for (int level = 0; level < numLevel; ++level) {
            int[] sr1 = src[level];
            if (sr1 == null) continue;
            int frameSize = (width >> level) * (height >> level);
            int[] ds1 = new int[frameSize * 3];
            dst[level] = ds1;
            int srcSize = sr1.length / 3;
            int srcPos = frameSize * frameIndex;
            int dstPos = 0;
            System.arraycopy(sr1, srcPos, ds1, dstPos, frameSize);
            System.arraycopy(sr1, srcPos += srcSize, ds1, dstPos += frameSize, frameSize);
            System.arraycopy(sr1, srcPos += srcSize, ds1, dstPos += frameSize, frameSize);
        }
        return dst;
    }

    public static int[][] prepareAF(elv tas, int[][] src, int width, int height) {
        boolean skip = true;
        return src;
    }

    public static void fixTransparentColor(elv tas, int[] aint) {
    }
}

