/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.core.other;

import com.minecraftabnormals.neapolitan.common.entity.goals.AvoidBlockGoal;
import com.minecraftabnormals.neapolitan.core.NeapolitanConfig;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEffects;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.abnormals_core.core.utils.TradeUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="neapolitan")
public class NeapolitanEvents {
    public static final String SAVAGE_AND_RAVAGE = "savageandravage";
    public static final ResourceLocation CREEPIE = new ResourceLocation("savageandravage", "creepie");

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)event.getEntity();
            creeper.field_70714_bg.func_75776_a(3, new AvoidBlockGoal((CreatureEntity)creeper, 6, 1.0, 1.2));
        } else if (entity instanceof MonsterEntity && entity.func_200600_R() != null && ModList.get().isLoaded(SAVAGE_AND_RAVAGE) && entity.func_200600_R() == ForgeRegistries.ENTITIES.getValue(CREEPIE)) {
            MonsterEntity creepie = (MonsterEntity)event.getEntity();
            creepie.field_70714_bg.func_75776_a(3, new AvoidBlockGoal((CreatureEntity)creepie, 6, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        Hand hand = event.getHand();
        PlayerEntity player = event.getPlayer();
        if (((Boolean)NeapolitanConfig.COMMON.milkingWithGlassBottles.get()).booleanValue() && entity.func_200600_R().func_220341_a(NeapolitanTags.EntityTypes.MILKABLE)) {
            boolean notChild;
            boolean bl = entity instanceof LivingEntity ? !((LivingEntity)entity).func_70631_g_() : (notChild = true);
            if (stack.func_77973_b() == Items.field_151069_bo && notChild) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                ItemStack itemstack1 = DrinkHelper.func_241445_a_((ItemStack)stack, (PlayerEntity)event.getPlayer(), (ItemStack)((Item)NeapolitanItems.MILK_BOTTLE.get()).func_190903_i());
                player.func_184609_a(hand);
                player.func_184611_a(hand, itemstack1);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        LivingEntity source = event.getExplosion().func_94613_c();
        if (source != null && (source instanceof CreeperEntity || ModList.get().isLoaded(SAVAGE_AND_RAVAGE) && source.func_200600_R() == ForgeRegistries.ENTITIES.getValue(CREEPIE)) && event.getWorld().func_180495_p(source.func_233580_cy_()).func_177230_c() == NeapolitanBlocks.STRAWBERRY_BUSH.get()) {
            for (Entity entity : event.getAffectedEntities()) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.func_70691_i(5.0f);
                }
                if (!(entity instanceof ServerPlayerEntity)) continue;
                NeapolitanCriteriaTriggers.CREEPER_HEAL.trigger((ServerPlayerEntity)entity);
            }
            event.getAffectedEntities().clear();
            event.getAffectedBlocks().clear();
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving().func_70660_b((Effect)NeapolitanEffects.VANILLA_SCENT.get()) != null && event.getPotionEffect().func_188419_a() != NeapolitanEffects.VANILLA_SCENT.get()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        VillagerProfession type = event.getType();
        Int2ObjectMap trades = event.getTrades();
        List novice = (List)trades.get(1);
        List journeyman = (List)trades.get(3);
        List expert = (List)trades.get(4);
        List master = (List)trades.get(5);
        if (type == VillagerProfession.field_221156_f) {
            novice.add(new TradeUtils.EmeraldsForItemsTrade((Item)NeapolitanItems.STRAWBERRIES.get(), 24, 1, 16, 2));
            journeyman.add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.STRAWBERRY_SCONES.get(), 3, 12, 12, 10));
            expert.add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.VANILLA_CAKE.get(), 3, 1, 12, 15));
            expert.add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.CHOCOLATE_CAKE.get(), 3, 1, 12, 15));
            expert.add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.STRAWBERRY_CAKE.get(), 3, 1, 12, 15));
        }
        if (type == VillagerProfession.field_221153_c) {
            master.add(new TradeUtils.EmeraldsForItemsTrade((Item)NeapolitanItems.DRIED_VANILLA_PODS.get(), 16, 1, 16, 30));
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.VANILLA_PODS.get(), 1, 3, 4, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Item)NeapolitanItems.WHITE_STRAWBERRIES.get(), 4, 8, 2, 1));
    }
}

