/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.item.ModItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class TooltipEvents {
    private static CompoundNBT lastNBT;
    private static ITextComponent lastFormatted;
    private static Function<CompoundNBT, ITextComponent> formatter;

    private TooltipEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void globalTooltip(ItemTooltipEvent event) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(event.getItemStack(), event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void debugTooltip(ItemTooltipEvent event) {
        if (!KiwiClientConfig.debugTooltip || !event.getFlags().func_194127_a()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (Screen.func_231173_s_() && stack.func_77942_o()) {
            tooltip.removeIf(c -> c.getClass() == TranslationTextComponent.class && ((TranslationTextComponent)c).func_150268_i().equals("item.nbt_tags"));
            if (lastNBT != stack.func_77978_p()) {
                switch (KiwiClientConfig.debugTooltipNBTFormatter) {
                    case "kiwi": {
                        formatter = tag -> {
                            TextFormatting[] colors = new TextFormatting[]{TextFormatting.LIGHT_PURPLE, TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA};
                            String s = tag.toString();
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            boolean quoted = false;
                            Iterator iterator = s.chars().boxed().collect(Collectors.toList()).iterator();
                            while (iterator.hasNext()) {
                                int ch = (Integer)iterator.next();
                                boolean special = false;
                                if (quoted) {
                                    if (ch == 34) {
                                        quoted = false;
                                        sb.appendCodePoint(ch);
                                        sb.append(TextFormatting.WHITE);
                                        continue;
                                    }
                                } else {
                                    if (ch == 58 || ch == 44) {
                                        sb.append(TextFormatting.GRAY);
                                        sb.appendCodePoint(ch);
                                        sb.append(TextFormatting.WHITE);
                                        continue;
                                    }
                                    if (ch == 34) {
                                        quoted = true;
                                        sb.append(TextFormatting.GRAY);
                                    } else if (ch == 123 || ch == 91) {
                                        ++i;
                                        special = true;
                                    } else if (ch == 125 || ch == 93) {
                                        special = true;
                                    }
                                }
                                if (special) {
                                    int colotIndex = i % colors.length;
                                    sb.append(colors[colotIndex]);
                                }
                                sb.appendCodePoint(ch);
                                if (!special) continue;
                                sb.append(TextFormatting.WHITE);
                                if (ch != 125 && ch != 93) continue;
                                --i;
                            }
                            return new StringTextComponent(sb.toString());
                        };
                        break;
                    }
                    case "vanilla": {
                        formatter = tag -> stack.func_77978_p().func_197637_c();
                        break;
                    }
                    default: {
                        formatter = tag -> new StringTextComponent(tag.toString());
                    }
                }
                lastNBT = stack.func_77978_p();
                lastFormatted = ((ITextComponent)formatter.apply((Object)lastNBT)).func_230532_e_().func_240699_a_(TextFormatting.RESET);
            }
            tooltip.add(lastFormatted);
        } else {
            stack.func_77973_b().getTags().stream().map(Object::toString).forEach(id -> tooltip.add(new StringTextComponent("#" + id).func_240699_a_(TextFormatting.DARK_GRAY)));
        }
    }
}

