/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;

public class ConfigHandler {
    private boolean master;
    private final String modId;
    private final String fileName;
    private final ModConfig.Type type;
    private ModConfig config;
    @Nullable
    private final Class<?> clazz;
    private final BiMap<Field, ForgeConfigSpec.ConfigValue<?>> valueMap = HashBiMap.create();

    public ConfigHandler(String modId, String fileName, ModConfig.Type type, Class<?> clazz, boolean master) {
        this.master = master;
        this.modId = modId;
        this.clazz = clazz;
        this.fileName = fileName;
        this.type = type;
        KiwiConfigManager.register(this);
    }

    public void init() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(this::build);
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.modId).orElseThrow(NullPointerException::new);
        this.config = new ModConfig(this.type, (ForgeConfigSpec)specPair.getRight(), modContainer, this.fileName);
        modContainer.addConfig(this.config);
        if (modContainer instanceof FMLModContainer) {
            ((FMLModContainer)modContainer).getEventBus().addListener(this::onFileChange);
        }
    }

    private ConfigHandler build(ForgeConfigSpec.Builder builder) {
        if (this.master) {
            KiwiConfigManager.defineModules(this.modId, builder);
        }
        if (this.clazz == null) {
            return this;
        }
        for (Field field : this.clazz.getFields()) {
            KiwiConfig.Path pathAnnotation;
            KiwiConfig.Translation translation;
            KiwiConfig.Comment comment;
            Class<?> type;
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || Modifier.isFinal(mods) || (type = field.getType()) != Integer.TYPE && type != Long.TYPE && type != Double.TYPE && type != Boolean.TYPE && type != String.class && !Enum.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type)) continue;
            if (field.getAnnotation(KiwiConfig.WorldRestart.class) != null) {
                builder.worldRestart();
            }
            if ((comment = field.getAnnotation(KiwiConfig.Comment.class)) != null) {
                builder.comment(comment.value());
            }
            if ((translation = field.getAnnotation(KiwiConfig.Translation.class)) != null) {
                builder.translation(this.modId + ".config." + translation.value());
            }
            String path = (pathAnnotation = field.getAnnotation(KiwiConfig.Path.class)) == null ? field.getName() : pathAnnotation.value();
            ForgeConfigSpec.ConfigValue value = null;
            try {
                if (type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE) {
                    double min = Double.NaN;
                    double max = Double.NaN;
                    KiwiConfig.Range range = field.getAnnotation(KiwiConfig.Range.class);
                    if (range != null) {
                        min = range.min();
                        max = range.max();
                    }
                    if (type == Integer.TYPE) {
                        value = builder.defineInRange(path, field.getInt(null), Double.isNaN(min) ? Integer.MIN_VALUE : (int)min, Double.isNaN(max) ? Integer.MAX_VALUE : (int)max);
                    } else if (type == Long.TYPE) {
                        value = builder.defineInRange(path, field.getLong(null), Double.isNaN(min) ? Long.MIN_VALUE : (long)min, Double.isNaN(max) ? Long.MAX_VALUE : (long)max);
                    } else if (type == Double.TYPE) {
                        value = builder.defineInRange(path, field.getDouble(null), Double.isNaN(min) ? Double.MIN_VALUE : min, Double.isNaN(max) ? Double.MAX_VALUE : max);
                    }
                } else if (type == String.class) {
                    value = builder.define(path, field.get(null));
                } else if (type == Boolean.TYPE) {
                    value = builder.define(path, field.getBoolean(null));
                } else if (Enum.class.isAssignableFrom(type)) {
                    value = builder.defineEnum(path, (Enum)field.get(null));
                } else if (List.class.isAssignableFrom(type)) {
                    value = builder.defineList(path, (List)field.get(null), (Predicate)Predicates.alwaysTrue());
                }
                this.valueMap.put((Object)field, (Object)value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Kiwi.logger.catching((Throwable)e);
            }
        }
        return this;
    }

    public void refresh() {
        this.valueMap.forEach((field, value) -> {
            try {
                Kiwi.logger.debug("Set " + field.getName() + " to " + value.get());
                field.set(null, value.get());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Kiwi.logger.catching((Throwable)e);
            }
        });
    }

    public void forceLoad() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        CommentedFileConfig configData = (CommentedFileConfig)this.config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(this.config);
        Field fCfg = ModConfig.class.getDeclaredField("configData");
        fCfg.setAccessible(true);
        fCfg.set(this.config, configData);
        this.config.getSpec().setConfig((CommentedConfig)configData);
        this.config.save();
    }

    @SubscribeEvent
    protected void onFileChange(ModConfig.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        this.refresh();
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isMaster() {
        return this.master;
    }

    public String getModId() {
        return this.modId;
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ForgeConfigSpec.ConfigValue<?> getValueByPath(String path) {
        Joiner joiner = Joiner.on((String)".");
        for (ForgeConfigSpec.ConfigValue value : this.valueMap.values()) {
            if (!path.equals(joiner.join((Iterable)value.getPath()))) continue;
            return value;
        }
        return null;
    }
}

