/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.KiwiClientConfig;

public class ModItem
extends Item {
    public ModItem(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flagIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addTip(ItemStack stack, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean ctrl;
        if (tooltip.isEmpty()) {
            return;
        }
        boolean shift = Screen.func_231173_s_();
        String key = shift == (ctrl = Screen.func_231172_r_()) ? stack.func_77977_a() + ".tip" : (shift ? stack.func_77977_a() + ".tip.shift" : stack.func_77977_a() + ".tip.ctrl");
        boolean hasKey = I18n.func_188566_a((String)key);
        if (!hasKey && shift != ctrl) {
            return;
        }
        if (hasKey) {
            ArrayList lines = Lists.newArrayList((Object[])I18n.func_135052_a((String)key, (Object[])new Object[0]).split("\n"));
            FontRenderer fontRenderer = stack.func_77973_b().getFontRenderer(stack);
            if (fontRenderer == null) {
                fontRenderer = Minecraft.func_71410_x().field_71466_p;
            }
            FontRenderer fontRenderer2 = fontRenderer;
            int width = Math.max(fontRenderer.func_78256_a(tooltip.get(0).getString()), KiwiClientConfig.tooltipWrapWidth);
            tooltip.addAll(lines.stream().map(StringTextComponent::new).map(s -> fontRenderer2.func_238425_b_((ITextProperties)s, width)).flatMap(Collection::stream).map(ITextProperties::getString).map(StringTextComponent::new).peek(c -> c.func_240699_a_(TextFormatting.GRAY)).collect(Collectors.toList()));
        }
        if (shift == ctrl) {
            boolean hasShiftKey = I18n.func_188566_a((String)(key + ".shift"));
            boolean hasCtrlKey = I18n.func_188566_a((String)(key + ".ctrl"));
            if (hasShiftKey && hasCtrlKey) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.kiwi.press_shift_or_ctrl"));
            } else if (hasShiftKey) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.kiwi.press_shift"));
            } else if (hasCtrlKey) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tip.kiwi.press_ctrl"));
            }
        }
    }
}

