/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule.impl;

import com.mojang.serialization.DynamicOps;
import java.util.function.IntPredicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.Logger;
import snownee.kiwi.Kiwi;
import snownee.kiwi.schedule.Task;
import snownee.kiwi.schedule.impl.WorldTicker;

public class SimpleWorldTask
extends Task<WorldTicker>
implements INBTSerializable<CompoundNBT> {
    protected int tick = 0;
    protected RegistryKey<World> dimension;
    protected TickEvent.Phase phase;
    protected IntPredicate function;

    public SimpleWorldTask() {
    }

    public SimpleWorldTask(World world, TickEvent.Phase phase, IntPredicate function) {
        this((RegistryKey<World>)world.func_234923_W_(), phase, function);
    }

    public SimpleWorldTask(RegistryKey<World> dimensionType, TickEvent.Phase phase, IntPredicate function) {
        this.dimension = dimensionType;
        this.phase = phase;
        this.function = function;
    }

    @Override
    public boolean tick(WorldTicker ticker) {
        return this.function.test(++this.tick);
    }

    @Override
    public WorldTicker ticker() {
        return WorldTicker.get(this.dimension, this.phase);
    }

    @Override
    public boolean shouldSave() {
        return this.getClass() != SimpleWorldTask.class;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("tick", this.tick);
        World.field_234917_f_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, this.dimension).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).ifPresent(nbt -> data.func_218657_a("world", nbt));
        data.func_74757_a("start", this.phase == TickEvent.Phase.START);
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dimension = World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a("world")).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).orElse(World.field_234918_g_);
        this.tick = nbt.func_74762_e("tick");
        this.phase = nbt.func_74767_n("start") ? TickEvent.Phase.START : TickEvent.Phase.END;
    }
}

