/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.DynamicOps;
import net.minecraft.dispenser.IPosition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;
import snownee.kiwi.Kiwi;

public class DimBlockPos
extends BlockPos {
    private RegistryKey<World> dim;

    public DimBlockPos(RegistryKey<World> dim, int x, int y, int z) {
        super(x, y, z);
        this.dim = dim;
    }

    public DimBlockPos(RegistryKey<World> dim, double x, double y, double z) {
        super(x, y, z);
        this.dim = dim;
    }

    public DimBlockPos(RegistryKey<World> dim, Vector3d vec) {
        super(vec);
        this.dim = dim;
    }

    public DimBlockPos(RegistryKey<World> dim, IPosition source) {
        super(source);
        this.dim = dim;
    }

    public DimBlockPos(RegistryKey<World> dim, Vector3i source) {
        super(source);
        this.dim = dim;
    }

    public DimBlockPos(World world, Vector3i source) {
        this((RegistryKey<World>)world.func_234923_W_(), source);
    }

    public RegistryKey<World> getDimension() {
        return this.dim;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof DimBlockPos)) {
            return false;
        }
        return this.getDimension() == ((DimBlockPos)((Object)that)).getDimension() && super.equals(that);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.getDimension().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("dim", this.dim).add("x", this.func_177958_n()).add("y", this.func_177956_o()).add("z", this.func_177952_p()).toString();
    }

    public static CompoundNBT write(DimBlockPos pos) {
        CompoundNBT data = new CompoundNBT();
        World.field_234917_f_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, pos.dim).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).ifPresent(nbt -> data.func_218657_a("Dim", nbt));
        data.func_74768_a("X", pos.func_177958_n());
        data.func_74768_a("Y", pos.func_177956_o());
        data.func_74768_a("Z", pos.func_177952_p());
        return data;
    }

    public static DimBlockPos read(CompoundNBT tag) {
        RegistryKey dimension = World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag.func_74781_a("Dim")).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).orElse(World.field_234918_g_);
        return new DimBlockPos((RegistryKey<World>)dimension, tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }
}

