/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public final class PlayerUtil {
    private PlayerUtil() {
    }

    @Nullable
    public static BlockPos tryPlace(World world, BlockPos pos, Direction side, @Nullable PlayerEntity player, Hand hand, BlockState state, @Nullable ItemStack stack, boolean playSound, boolean skipCollisionCheck) {
        ISelectionContext iselectioncontext;
        BlockState worldState = world.func_180495_p(pos);
        if (!(worldState.func_177230_c() == Blocks.field_150433_aE && worldState.func_235901_b_((Property)SnowBlock.field_176315_a) && (Integer)worldState.func_177229_b((Property)SnowBlock.field_176315_a) < 8 || state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, pos, side.func_176734_d(), stack == null ? ItemStack.field_190927_a : stack, side.func_176734_d())))) {
            pos = pos.func_177972_a(side);
        }
        if (skipCollisionCheck) {
            return PlayerUtil.tryPlace(world, pos, side.func_176734_d(), player, hand, state, stack, playSound) ? pos : null;
        }
        ISelectionContext iSelectionContext = iselectioncontext = player == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)player);
        if (world.func_226663_a_(state, pos, iselectioncontext)) {
            return PlayerUtil.tryPlace(world, pos, side.func_176734_d(), player, hand, state, stack, playSound) ? pos : null;
        }
        return null;
    }

    public static boolean tryPlace(World world, BlockPos pos, Direction direction, @Nullable PlayerEntity player, Hand hand, BlockState state, @Nullable ItemStack stack, boolean playSound) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (player != null && !player.func_175151_a(pos, direction, stack)) {
            return false;
        }
        BlockSnapshot blocksnapshot = BlockSnapshot.create((IWorld)world, (BlockPos)pos);
        if (!world.func_175656_a(pos, state)) {
            return false;
        }
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)direction)) {
            blocksnapshot.restore(true, false);
            return false;
        }
        world.func_180501_a(pos, state, 11);
        BlockState actualState = world.func_180495_p(pos);
        if (stack != null) {
            BlockItem.func_179224_a((World)world, (PlayerEntity)player, (BlockPos)pos, (ItemStack)stack);
            if (player != null) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
                }
                actualState.func_177230_c().func_180633_a(world, pos, state, (LivingEntity)player, stack);
            }
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (playSound) {
            SoundType soundtype = actualState.func_177230_c().getSoundType(actualState, (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        return true;
    }

    public static boolean canTouch(PlayerEntity player, BlockPos pos) {
        double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= reach * reach;
    }
}

