/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientListOverlay
implements IIngredientListOverlay,
IMouseHandler,
IShowsRecipeFocuses {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private boolean hasRoom;
    private final IngredientFilter ingredientFilter;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter searchField;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private Rectangle2d displayArea = new Rectangle2d(0, 0, 0, 0);
    @Nullable
    private IGuiProperties guiProperties;

    private static boolean isSearchBarCentered(IGuiProperties guiProperties) {
        return ClientConfig.getInstance().isCenterSearchBarEnabled() && guiProperties.getGuiTop() + guiProperties.getGuiYSize() + 20 < guiProperties.getScreenHeight();
    }

    public IngredientListOverlay(IngredientFilter ingredientFilter, IngredientManager ingredientManager, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IWorldConfig worldConfig) {
        this.ingredientFilter = ingredientFilter;
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.worldConfig = worldConfig;
        ingredientFilter.addListener(() -> this.onSetFilterText(worldConfig.getFilterText()));
        this.searchField = new GuiTextFieldFilter(ingredientFilter, worldConfig);
        this.configButton = ConfigButton.create(this, worldConfig);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, ingredientManager, worldConfig);
        this.setKeyboardFocus(false);
    }

    public void rebuildIngredientFilter() {
        LOGGER.info("Updating ingredient filter...");
        long start_time = System.currentTimeMillis();
        this.ingredientFilter.modesChanged();
        LOGGER.info("Updated  ingredient filter in {} ms", (Object)(System.currentTimeMillis() - start_time));
        this.updateLayout(true);
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static Rectangle2d getDisplayArea(IGuiProperties guiProperties) {
        int x = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + 2;
        int y = 2;
        int width = guiProperties.getScreenWidth() - x - 2;
        int height = guiProperties.getScreenHeight() - 2 - 2;
        return new Rectangle2d(x, 2, width, height);
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean forceUpdate) {
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.setKeyboardFocus(false);
                this.ghostIngredientDragManager.stopDrag();
            }
        } else if (forceUpdate || this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties)) {
            this.guiProperties = guiProperties;
            this.displayArea = IngredientListOverlay.getDisplayArea(guiProperties);
            boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(guiProperties);
            int searchHeight = searchBarCentered ? 0 : 22;
            Set<Rectangle2d> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
            Rectangle2d availableContentsArea = new Rectangle2d(this.displayArea.func_199318_a(), this.displayArea.func_199319_b(), this.displayArea.func_199316_c(), this.displayArea.func_199317_d() - searchHeight);
            this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas, 80);
            Rectangle2d contentsArea = this.contents.getArea();
            this.displayArea = new Rectangle2d(contentsArea.func_199318_a(), this.displayArea.func_199319_b(), contentsArea.func_199316_c(), this.displayArea.func_199317_d());
            if (searchBarCentered && this.isListDisplayed()) {
                this.searchField.updateBounds(new Rectangle2d(guiProperties.getGuiLeft(), guiProperties.getScreenHeight() - 20 - 2, guiProperties.getGuiXSize() - 20 + 1, 20));
            } else {
                this.searchField.updateBounds(new Rectangle2d(this.displayArea.func_199318_a(), this.displayArea.func_199319_b() + this.displayArea.func_199317_d() - 20 - 2, this.displayArea.func_199316_c() - 20 + 1, 20));
            }
            this.configButton.updateBounds(new Rectangle2d(this.searchField.field_230690_l_ + this.searchField.func_230998_h_() - 1, this.searchField.field_230691_m_, 20, 20));
            this.updateLayout(false);
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            this.worldConfig.saveFilterText();
        }
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.guiProperties != null) {
            if (this.isListDisplayed()) {
                RenderSystem.disableLighting();
                this.searchField.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
                this.contents.draw(minecraft, matrixStack, mouseX, mouseY, partialTicks);
                this.configButton.draw(matrixStack, mouseX, mouseY, partialTicks);
            } else {
                this.configButton.draw(matrixStack, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.configButton.drawTooltips(matrixStack, mouseX, mouseY);
            this.ghostIngredientDragManager.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
        } else if (this.guiProperties != null) {
            this.configButton.drawTooltips(matrixStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, MatrixStack matrixStack, ContainerScreen gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(-gui.getGuiLeft()), (double)(-gui.getGuiTop()), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, matrixStack, mouseX, mouseY);
            matrixStack.func_227865_b_();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            if (ClientConfig.getInstance().isCenterSearchBarEnabled() && this.searchField.isMouseOver(mouseX, mouseY)) {
                return true;
            }
            return MathUtil.contains(this.displayArea, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        IClickedIngredient<?> clicked;
        if (this.isListDisplayed() && (clicked = this.contents.getIngredientUnderMouse(mouseX, mouseY)) != null) {
            clicked.setOnClickHandler(() -> this.setKeyboardFocus(false));
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isListDisplayed()) {
            IClickedIngredient<?> clicked;
            if (this.ghostIngredientDragManager.handleMouseClicked(mouseX, mouseY)) {
                return true;
            }
            if (this.configButton.handleMouseClick(mouseX, mouseY, mouseButton)) {
                return true;
            }
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.setKeyboardFocus(false);
                return false;
            }
            if (this.contents.handleMouseClicked(mouseX, mouseY, mouseButton)) {
                this.setKeyboardFocus(false);
                return true;
            }
            boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
            this.setKeyboardFocus(searchClicked);
            if (searchClicked) {
                boolean updated = this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton);
                if (updated) {
                    this.updateLayout(false);
                }
                return true;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            Screen currentScreen = minecraft.field_71462_r;
            InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
            if (currentScreen != null && !(currentScreen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.field_71474_y.field_74322_I.isActiveAndMatches(input)) && (clicked = this.getIngredientUnderMouse(mouseX, mouseY)) != null) {
                ItemStack mouseItem;
                if (this.worldConfig.isCheatItemsEnabled()) {
                    ItemStack itemStack = clicked.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.giveStack(itemStack, input);
                    }
                    clicked.onClickHandled();
                    return true;
                }
                ClientPlayerEntity player = minecraft.field_71439_g;
                if (player != null && (mouseItem = player.field_71071_by.func_70445_o()).func_190926_b() && this.ghostIngredientDragManager.handleClickGhostIngredient(currentScreen, clicked)) {
                    return true;
                }
            }
        } else if (this.guiProperties != null) {
            return this.configButton.handleMouseClick(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.isListDisplayed() && this.isMouseOver(mouseX, mouseY) && this.contents.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.func_230999_j_();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_230996_d_(keyboardFocus);
    }

    public boolean onGlobalKeyPressed(InputMappings.Input input) {
        if (this.isListDisplayed()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(input)) {
                this.worldConfig.toggleCheatItemsEnabled();
                return true;
            }
            if (KeyBindings.toggleEditMode.isActiveAndMatches(input)) {
                this.worldConfig.toggleEditModeEnabled();
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(input)) {
                this.setKeyboardFocus(true);
                return true;
            }
        }
        return false;
    }

    public boolean onCharTyped(char codePoint, int modifiers) {
        if (this.isListDisplayed() && this.hasKeyboardFocus() && this.searchField.func_231042_a_(codePoint, modifiers)) {
            boolean changed = this.worldConfig.setFilterText(this.searchField.func_146179_b());
            if (changed) {
                this.updateLayout(true);
            }
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isListDisplayed()) {
            if (this.hasKeyboardFocus() && this.searchField.func_231046_a_(keyCode, scanCode, modifiers)) {
                boolean changed = this.worldConfig.setFilterText(this.searchField.func_146179_b());
                if (changed) {
                    this.updateLayout(true);
                }
                return true;
            }
            return this.contents.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement elementUnderMouse;
        if (this.isListDisplayed() && (elementUnderMouse = this.contents.getElementUnderMouse()) != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }

    public void onSetFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        this.updateLayout(true);
    }

    @Override
    public ImmutableList<Object> getVisibleIngredients() {
        if (this.isListDisplayed()) {
            ImmutableList.Builder visibleIngredients = ImmutableList.builder();
            List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
            for (IIngredientListElement element : visibleElements) {
                Object ingredient = element.getIngredient();
                visibleIngredients.add(ingredient);
            }
            return visibleIngredients.build();
        }
        return ImmutableList.of();
    }
}

