/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import mezz.jei.config.Constants;
import mezz.jei.recipes.ExtendableRecipeCategoryHelper;
import mezz.jei.util.Translator;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Size2i;

public class CraftingRecipeCategory
implements IExtendableRecipeCategory<ICraftingRecipe, ICraftingCategoryExtension> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final IModIdHelper modIdHelper;
    private final ExtendableRecipeCategoryHelper<IRecipe, ICraftingCategoryExtension> extendableHelper = new ExtendableRecipeCategoryHelper(ICraftingRecipe.class);

    public CraftingRecipeCategory(IGuiHelper guiHelper, IModIdHelper modIdHelper) {
        this.modIdHelper = modIdHelper;
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableIngredient(new ItemStack((IItemProvider)Blocks.field_150462_ai));
        this.localizedName = Translator.translateToLocal("gui.jei.category.craftingTable");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.CRAFTING;
    }

    @Override
    public Class<? extends ICraftingRecipe> getRecipeClass() {
        return ICraftingRecipe.class;
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, ICraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        ICraftingCategoryExtension recipeExtension = this.extendableHelper.getRecipeExtension(recipe);
        if (recipeExtension instanceof ICustomCraftingCategoryExtension) {
            ICustomCraftingCategoryExtension customExtension = (ICustomCraftingCategoryExtension)recipeExtension;
            customExtension.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List<List<ItemStack>> outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        Size2i size = recipeExtension.getSize();
        if (size != null && size.width > 0 && size.height > 0) {
            this.craftingGridHelper.setInputs(guiItemStacks, inputs, size.width, size.height);
        } else {
            this.craftingGridHelper.setInputs(guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, outputs.get(0));
        ResourceLocation registryName = recipeExtension.getRegistryName();
        if (registryName != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    if (this.modIdHelper.isDisplayingModNameEnabled()) {
                        String recipeModId = registryName.func_110624_b();
                        boolean modIdDifferent = false;
                        ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                        if (itemRegistryName != null) {
                            String itemModId = itemRegistryName.func_110624_b();
                            boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                        }
                        if (modIdDifferent) {
                            String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                            TranslationTextComponent recipeBy = new TranslationTextComponent("jei.tooltip.recipe.by", new Object[]{modName});
                            tooltip.add(recipeBy.func_240699_a_(TextFormatting.GRAY));
                        }
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
                    if (showAdvanced) {
                        TranslationTextComponent recipeId = new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{registryName.toString()});
                        tooltip.add(recipeId.func_240699_a_(TextFormatting.DARK_GRAY));
                    }
                }
            });
        }
    }

    @Override
    public void setIngredients(ICraftingRecipe recipe, IIngredients ingredients) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        extension.setIngredients(ingredients);
    }

    @Override
    public void draw(ICraftingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        int recipeWidth = this.background.getWidth();
        int recipeHeight = this.background.getHeight();
        extension.drawInfo(recipeWidth, recipeHeight, matrixStack, mouseX, mouseY);
    }

    @Override
    public List<ITextComponent> getTooltipStrings(ICraftingRecipe recipe, double mouseX, double mouseY) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        return extension.getTooltipStrings(mouseX, mouseY);
    }

    @Override
    public boolean handleClick(ICraftingRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        return extension.handleClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public <R extends ICraftingRecipe> void addCategoryExtension(Class<? extends R> recipeClass, Function<R, ? extends ICraftingCategoryExtension> extensionFactory) {
        this.extendableHelper.addRecipeExtensionFactory(recipeClass, extensionFactory);
    }
}

