/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.minecraft.PluginMinecraft;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HUDHandlerVanilla
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    static final HUDHandlerVanilla INSTANCE = new HUDHandlerVanilla();
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        if (config.get(PluginMinecraft.CONFIG_HIDE_SILVERFISH) && accessor.getBlock() instanceof SilverfishBlock) {
            return new ItemStack((IItemProvider)((SilverfishBlock)accessor.getBlock()).func_196468_d().func_199767_j());
        }
        if (accessor.getBlock() == Blocks.field_150464_aj) {
            return new ItemStack((IItemProvider)Items.field_151015_O);
        }
        if (accessor.getBlock() == Blocks.field_185773_cZ) {
            return new ItemStack((IItemProvider)Items.field_185164_cV);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(PluginMinecraft.CONFIG_HIDE_SILVERFISH) && accessor.getBlock() instanceof SilverfishBlock) {
            ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getBlockName(), accessor.getStack().func_200301_q().getString())));
        }
        if (accessor.getBlock() == Blocks.field_150474_ac && config.get(PluginMinecraft.CONFIG_SPAWNER_TYPE)) {
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)accessor.getTileEntity();
            ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new TranslationTextComponent(accessor.getBlock().func_149739_a()).func_230529_a_((ITextComponent)new StringTextComponent(" (")).func_230529_a_(spawner.func_145881_a().func_184994_d().func_145748_c_()).func_230529_a_((ITextComponent)new StringTextComponent(")")));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(PluginMinecraft.CONFIG_CROP_PROGRESS)) {
            if (accessor.getBlock() instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)accessor.getBlock();
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)crop.func_185524_e())).intValue() / (float)crop.func_185526_g());
            } else if (accessor.getBlock() == Blocks.field_150394_bc || accessor.getBlock() == Blocks.field_150393_bb) {
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208170_W)).intValue() / 7.0f);
            } else if (accessor.getBlock() == Blocks.field_150375_by) {
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208167_T)).intValue() / 2.0f);
            }
        }
        if (config.get(PluginMinecraft.CONFIG_LEVER) && accessor.getBlock() instanceof LeverBlock) {
            boolean active = (Boolean)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208194_u);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.state", new Object[]{new TranslationTextComponent("tooltip.waila.state_" + (active ? "on" : "off"))}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_REPEATER) && accessor.getBlock() == Blocks.field_196633_cV) {
            int delay = (Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208126_aa);
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.tooltip.delay", new Object[]{delay}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_COMPARATOR) && accessor.getBlock() == Blocks.field_196762_fd) {
            ComparatorMode mode = (ComparatorMode)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208141_ap);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.mode", new Object[]{new TranslationTextComponent("tooltip.waila.mode_." + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor"))}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_REDSTONE) && accessor.getBlock() == Blocks.field_150488_af) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.power", new Object[]{accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208136_ak)}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_JUKEBOX) && accessor.getBlock() == Blocks.field_150421_aI) {
            if (accessor.getServerData().func_74764_b("record")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("record.nowPlaying", new Object[]{ITextComponent.Serializer.func_240643_a_((String)accessor.getServerData().func_74779_i("record"))}));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.empty"));
            }
        }
    }

    @Override
    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity blockEntity) {
        if (blockEntity instanceof JukeboxTileEntity) {
            JukeboxTileEntity jukebox = (JukeboxTileEntity)blockEntity;
            data.func_74778_a("record", ITextComponent.Serializer.func_150696_a((ITextComponent)jukebox.func_195537_c().func_200301_q()));
        }
    }

    private static void addMaturityTooltip(List<ITextComponent> tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{new TranslationTextComponent("tooltip.waila.crop_mature")}));
        }
    }
}

