/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiOptions
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public GuiOptions(Screen parent, TextComponent title, Runnable saver, Runnable canceller) {
        super((ITextComponent)title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public GuiOptions(Screen parent, TextComponent title) {
        this(parent, title, null, null);
    }

    public void func_231158_b_(Minecraft client, int width, int height) {
        super.func_231158_b_(client, width, height);
        this.options = this.getOptions();
        this.field_230705_e_.add(this.options);
        this.func_231035_a_((IGuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.func_230480_a_((Widget)new Button(width / 2 - 100, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
            this.func_230480_a_((Widget)new Button(width / 2 + 5, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), w -> {
                this.canceller.run();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
        } else {
            this.func_230480_a_((Widget)new Button(width / 2 - 50, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        OptionsEntryValue value;
        this.func_230446_a_(matrixStack);
        this.options.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_238472_a_(matrixStack, this.field_230712_o_, (ITextProperties)this.field_230704_d_, this.field_230708_k_ / 2, 12, 0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.field_230709_l_ - 32) {
            return;
        }
        OptionsListWidget.Entry entry = (OptionsListWidget.Entry)this.options.func_230958_g_();
        if (entry instanceof OptionsEntryValue && I18n.func_188566_a((String)(value = (OptionsEntryValue)entry).getDescription())) {
            int valueX = value.getX() + 10;
            String title = value.getTitle().getString();
            if (mouseX < valueX || mouseX > valueX + this.field_230712_o_.func_78256_a(title)) {
                return;
            }
            ArrayList tooltip = Lists.newArrayList((Object[])new ITextProperties[]{new StringTextComponent(title)});
            tooltip.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(value.getDescription()), 200));
            this.func_238654_b_(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    public IGuiEventListener func_230481_d_(IGuiEventListener listener) {
        this.field_230705_e_.add(listener);
        return listener;
    }

    public abstract OptionsListWidget getOptions();
}

