/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> mobSpecificDropChances;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableStandardHeads;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableLootingEnchant;
        public final ForgeConfigSpec.ConfigValue<Double> overallDropChance;
        public final ForgeConfigSpec.ConfigValue<Double> creeperSkeletonZombieDropChance;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.mobSpecificDropChances = builder.comment("If enabled, overrides the 'overallDropChance' variable with the specific values.").define("mobSpecificDropChances", true);
            this.enableStandardHeads = builder.comment("If enabled, allows Creepers, Skeletons and Zombies to drop their heads.").define("enableStandardHeads", false);
            this.enableLootingEnchant = builder.comment("If enabled, the looting enchant will have an effect on the drop chance.").define("enableLootingEnchant", true);
            this.overallDropChance = builder.comment("Sets the chance of a mob dropping its head if 'mobSpecificDropChances' is disabled.").defineInRange("overallDropChance", 0.1, 1.0E-4, 1.0);
            this.creeperSkeletonZombieDropChance = builder.comment("Sets head drop chance for Zombies, Skeletons and Creepers if 'enableStandardHeads' is enabled.").defineInRange("creeperSkeletonZombieDropChance", 0.1, 1.0E-4, 1.0);
            builder.pop();
        }
    }
}

