/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SideRoom
extends MineshaftPiece {
    private boolean hasDownstairs;
    private static final int SECONDARY_AXIS_LEN = 10;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 9;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SideRoom(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM, compoundTag);
        this.hasDownstairs = compoundTag.func_74767_n("hasDownstairs");
    }

    public SideRoom(int i, int pieceChainLen, Random random, MutableBoundingBox blockBox, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM, i, pieceChainLen, type);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        tag.func_74757_a("hasDownstairs", this.hasDownstairs);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 10, 5, 5, direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        if (random.nextInt(4) == 0) {
            Direction direction = this.func_186165_e();
            if (direction == null) {
                return;
            }
            MineshaftPiece newDungeonPiece = null;
            switch (direction) {
                case NORTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78892_f, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case SOUTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case WEST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c + 6, this.func_186165_e(), this.func_74877_c(), 0);
                    break;
                }
                case EAST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 4, this.field_74887_e.field_78896_c + 6, this.func_186165_e(), this.func_74877_c(), 0);
                }
            }
            if (newDungeonPiece != null) {
                this.hasDownstairs = true;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        this.fill((IWorld)world, box, random, 0, 0, 0, 9, 1, 4, this.getBrickSelector());
        this.replaceNonAir((IWorld)world, box, random, 0, 2, 0, 9, 3, 4, this.getBrickSelector());
        this.fill((IWorld)world, box, 1, 1, 1, 8, 3, 4, field_202556_l);
        boolean[][] ceiling = new boolean[10][5];
        for (int x = 0; x <= 9; ++x) {
            for (int z = 0; z <= 4; ++z) {
                BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, 4, z, box);
                if (currState == null || currState.func_196958_f()) continue;
                this.func_175811_a((IWorld)world, this.getBrickSelector().get(random), x, 4, z, box);
                ceiling[x][z] = true;
            }
        }
        if (!this.hasDownstairs) {
            this.generateLegs((IWorld)world, random);
        }
        if (random.nextInt(2) == 0) {
            this.func_175811_a((IWorld)world, (BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((Property)FurnaceBlock.field_220090_a, (Comparable)Direction.NORTH), 2, 1, 1, box);
            TileEntity blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(2, 1), this.func_74862_a(1), this.func_74873_b(2, 1)));
            if (blockEntity instanceof FurnaceTileEntity) {
                ((FurnaceTileEntity)blockEntity).func_70299_a(1, new ItemStack((IItemProvider)Items.field_151044_h, random.nextInt(33)));
            }
        }
        if (random.nextInt(2) == 0) {
            this.func_175811_a((IWorld)world, (BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((Property)FurnaceBlock.field_220090_a, (Comparable)Direction.NORTH), 1, 1, 1, box);
            TileEntity blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(1, 1), this.func_74862_a(1), this.func_74873_b(1, 1)));
            if (blockEntity instanceof FurnaceTileEntity) {
                ((FurnaceTileEntity)blockEntity).func_70299_a(1, new ItemStack((IItemProvider)Items.field_151044_h, random.nextInt(33)));
            }
        }
        this.chanceAddBlock((IWorld)world, random, 0.5f, Blocks.field_150462_ai.func_176223_P(), 3, 1, 1, box);
        if (random.nextInt(4) == 0) {
            this.addBarrel((IWorld)world, box, random, 8, 1, 1, LootTables.field_186424_f);
        }
        if (this.hasDownstairs) {
            this.func_175811_a((IWorld)world, (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)Direction.NORTH), 6, 0, 1, box);
            this.func_175811_a((IWorld)world, (BlockState)this.getTrapdoor().func_206870_a((Property)TrapDoorBlock.field_185512_D, (Comparable)Direction.NORTH), 6, 1, 1, box);
        }
        this.generateIronBarSupports((IWorld)world, box, random, ceiling);
        this.addBiomeDecorations((IWorld)world, box, random, 0, 0, 0, 9, 3, 4);
        this.addVines((IWorld)world, box, random, this.getVineChance(), 1, 0, 1, 8, 4, 3);
        return true;
    }

    private void generateLegs(IWorld world, Random random) {
        this.generateLeg(world, random, 1, 1, this.getBrickSelector());
        this.generateLeg(world, random, 1, 3, this.getBrickSelector());
        this.generateLeg(world, random, 8, 1, this.getBrickSelector());
        this.generateLeg(world, random, 8, 3, this.getBrickSelector());
    }

    private void generateIronBarSupports(IWorld world, MutableBoundingBox box, Random random, boolean[][] ceiling) {
        LinkedList invalidXs = Lists.newLinkedList();
        for (int z = 2; z <= 3; ++z) {
            for (int x = 2; x <= 7; ++x) {
                if (invalidXs.contains(x) || !ceiling[x][z] || random.nextInt(5) != 0) continue;
                this.fill(world, box, x, 1, z, x, 3, z, Blocks.field_150411_aY.func_176223_P());
                invalidXs.add(x);
                ++x;
            }
        }
    }
}

