/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.api.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

public class GenerationUtils {
    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static <B extends BlockState> boolean isProperBlock(B blockState, Block[] validBlocks, boolean orSolid) {
        if (!Arrays.asList(validBlocks).contains(blockState.func_177230_c()) && orSolid) {
            return blockState.func_200132_m();
        }
        return Arrays.asList(validBlocks).contains(blockState.func_177230_c());
    }

    public static void fillAreaWithBlockCube(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j() || xx != x2 && zz != z2) continue;
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeUnsafe(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeUnsafeReverse(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx >= x2; --xx) {
                for (int zz = z1; zz >= z2; --zz) {
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static void fillWithRandomTwoBlocksCube(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, Random rand, BlockState block, BlockState block2, float chance) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    if (rand.nextFloat() <= chance) {
                        world.func_180501_a(new BlockPos(xx, yy, zz), block2, 2);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(xx, yy, zz), block, 2);
                }
            }
        }
    }

    public static boolean isAreaReplacable(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaAir(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAreaCompletelySolid(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int yy = y1; yy <= y2; ++yy) {
            for (int xx = x1; xx <= x2; ++xx) {
                for (int zz = z1; zz <= z2; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_185904_a().func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos getClosestPositionToPos(List<BlockPos> positions, BlockPos pos) {
        double distance = -1.0;
        BlockPos currentPos = null;
        for (BlockPos listOfPositions : positions) {
            double newDistance = Vector3d.func_237489_a_((Vector3i)pos).func_72436_e(Vector3d.func_237489_a_((Vector3i)listOfPositions));
            if (distance != -1.0 && !(newDistance < distance)) continue;
            distance = newDistance;
            currentPos = listOfPositions;
        }
        return currentPos;
    }
}

