/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.client.particle;

import endergeticexpansion.client.particle.PoiseBubbleParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class EEParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"endergetic");
    public static final RegistryObject<BasicParticleType> POISE_BUBBLE = EEParticles.createBasicParticleType(true, "poise_bubble");
    public static final RegistryObject<BasicParticleType> SHORT_POISE_BUBBLE = EEParticles.createBasicParticleType(true, "short_poise_bubble");

    private static RegistryObject<BasicParticleType> createBasicParticleType(boolean alwaysShow, String name) {
        RegistryObject particleType = PARTICLES.register(name, () -> new BasicParticleType(alwaysShow));
        return particleType;
    }

    private static boolean checkForNonNullWithReflectionCauseForgeIsBaby(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }

    @Mod.EventBusSubscriber(modid="endergetic", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterParticleFactories {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
            if (EEParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)POISE_BUBBLE)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)POISE_BUBBLE.get(), PoiseBubbleParticle.Factory::new);
            }
            if (EEParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)SHORT_POISE_BUBBLE)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SHORT_POISE_BUBBLE.get(), PoiseBubbleParticle.ShortFactory::new);
            }
        }
    }
}

