/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.client.render.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import endergeticexpansion.common.entities.booflo.BoofloEntity;
import endergeticexpansion.core.registry.EEItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerRendererBoofloFruit
extends LayerRenderer<BoofloEntity, EntityModel<BoofloEntity>> {
    public LayerRendererBoofloFruit(IEntityRenderer<BoofloEntity, EntityModel<BoofloEntity>> renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn, BoofloEntity booflo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (booflo.hasCaughtFruit() && !booflo.isBoofed() && booflo.isEndimationPlaying(BoofloEntity.EAT) && booflo.getAnimationTick() > 20) {
            matrixStack.func_227860_a_();
            Vector3d fruitPos = new Vector3d(-1.25, 0.0, 0.0).func_178785_b(-netHeadYaw * ((float)Math.PI / 180) - 1.5707964f);
            matrixStack.func_227861_a_(fruitPos.func_82615_a(), fruitPos.func_82617_b() + (double)1.15f + (double)this.getFruitPosOffset(booflo), fruitPos.func_82616_c());
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(1.3f, 1.3f, 1.3f);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)booflo, new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get()), ItemCameraTransforms.TransformType.GROUND, false, matrixStack, bufferIn, packedLightIn);
            matrixStack.func_227865_b_();
        }
    }

    private float getFruitPosOffset(BoofloEntity booflo) {
        return 0.22f * booflo.FRUIT_HOVER.getAnimationProgress();
    }
}

