/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import com.google.common.collect.Maps;
import endergeticexpansion.core.events.PlayerEvents;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class CorrockBlock
extends Block {
    private static final Map<DimensionType, Supplier<Block>> CONVERSIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), conversions -> {
        conversions.put(DimensionTypeAccessor.OVERWORLD, () -> (Block)EEBlocks.CORROCK_OVERWORLD_BLOCK.get());
        conversions.put(DimensionTypeAccessor.THE_NETHER, () -> (Block)EEBlocks.CORROCK_NETHER_BLOCK.get());
        conversions.put(DimensionTypeAccessor.THE_END, () -> (Block)EEBlocks.CORROCK_END_BLOCK.get());
    });
    public final boolean petrified;

    public CorrockBlock(AbstractBlock.Properties properties, boolean petrified) {
        super(properties);
        this.petrified = petrified;
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!this.petrified && !this.isInProperDimension((World)world)) {
            world.func_175656_a(pos, ((Block)((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get()).func_176223_P());
        }
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SoundType.field_211383_n;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        if (this.isSubmerged(worldIn, currentPos)) {
            return !this.petrified ? PlayerEvents.convertCorrockBlock(stateIn) : stateIn;
        }
        return stateIn;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        return this.func_176223_P();
    }

    public boolean isInProperDimension(World world) {
        return !this.petrified && ((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get() == this;
    }

    public boolean isSubmerged(IWorld world, BlockPos pos) {
        for (Direction offsets : Direction.values()) {
            FluidState fluidState = world.func_204610_c(pos.func_177972_a(offsets));
            if (fluidState.func_206888_e() || !fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    public static class DimensionTypeAccessor
    extends DimensionType {
        public static final DimensionType OVERWORLD = field_236004_h_;
        public static final DimensionType THE_NETHER = field_236005_i_;
        public static final DimensionType THE_END = field_236006_j_;

        private DimensionTypeAccessor(OptionalLong p_i241243_1_, boolean p_i241243_2_, boolean p_i241243_3_, boolean p_i241243_4_, boolean p_i241243_5_, boolean p_i241243_6_, boolean p_i241243_7_, boolean p_i241243_8_, boolean p_i241243_9_, boolean p_i241243_10_, boolean p_i241243_11_, int p_i241243_12_, IBiomeMagnifier p_i241243_13_, ResourceLocation p_i241243_14_, float p_i241243_15_) {
            super(p_i241243_1_, p_i241243_2_, p_i241243_3_, p_i241243_4_, p_i241243_5_, p_i241243_6_, p_i241243_7_, p_i241243_8_, p_i241243_9_, p_i241243_10_, p_i241243_11_, p_i241243_12_, p_i241243_13_, p_i241243_14_, p_i241243_15_);
        }
    }
}

