/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import endergeticexpansion.common.blocks.CorrockBlock;
import endergeticexpansion.common.blocks.CorrockCrownBlock;
import endergeticexpansion.common.blocks.CorrockCrownStandingBlock;
import endergeticexpansion.core.events.PlayerEvents;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CorrockCrownWallBlock
extends CorrockCrownBlock {
    private static final Map<DimensionType, Supplier<CorrockCrownWallBlock>> CONVERSIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), conversions -> {
        conversions.put(CorrockBlock.DimensionTypeAccessor.OVERWORLD, () -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_OVERWORLD_WALL.get());
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_NETHER, () -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_NETHER_WALL.get());
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_END, () -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_END_WALL.get());
    });
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)0.0, (double)2.0, (double)12.5, (double)16.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)14.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0)));

    public CorrockCrownWallBlock(AbstractBlock.Properties builder, boolean petrified) {
        super(builder, petrified);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!this.isInProperDimension((World)world)) {
            world.func_175656_a(pos, (BlockState)((CorrockCrownWallBlock)((Object)((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<CorrockCrownWallBlock>)EEBlocks.CORROCK_CROWN_OVERWORLD_WALL)).get())).func_176223_P().func_206870_a((Property)FACING, world.func_180495_p(pos).func_177229_b((Property)FACING)));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        return Block.func_220055_a((IWorldReader)world, (BlockPos)blockpos, (Direction)direction);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        World iworldreaderbase = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        Direction[] aDirection = context.func_196009_e();
        if (!this.petrified && !this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        for (Direction Direction2 : aDirection) {
            Direction Direction1;
            if (!Direction2.func_176740_k().func_176722_c() || !(state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)(Direction1 = Direction2.func_176734_d()))).func_196955_c((IWorldReader)iworldreaderbase, blockpos) || iworldreaderbase.func_180495_p(blockpos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_177230_c() instanceof CorrockCrownWallBlock || iworldreaderbase.func_180495_p(blockpos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_177230_c() instanceof CorrockCrownStandingBlock) continue;
            return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206882_g() >= 8));
        }
        return null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            if (!this.petrified) {
                return PlayerEvents.convertCorrockBlock(stateIn);
            }
        }
        if (!(((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue() || this.petrified || this.isInProperDimension(worldIn.func_201672_e()))) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        if (facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return facing.func_176734_d() == stateIn.func_177229_b((Property)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean isInProperDimension(World world) {
        return !this.petrified && ((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<CorrockCrownWallBlock>)EEBlocks.CORROCK_CROWN_OVERWORLD_WALL)).get() == this;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }
}

