/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo.ai;

import endergeticexpansion.common.entities.bolloom.BolloomFruitEntity;
import endergeticexpansion.common.entities.booflo.BoofloAdolescentEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;

public class AdolescentAttackGoal
extends Goal {
    protected final BoofloAdolescentEntity attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private long field_220720_k;
    private boolean canPenalize = false;

    public AdolescentAttackGoal(BoofloAdolescentEntity attacker, double speedIn, boolean useLongMemory) {
        this.attacker = attacker;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        long i = this.attacker.field_70170_p.func_82737_E();
        if (i - this.field_220720_k < 20L) {
            return false;
        }
        if (!this.attacker.isHungry()) {
            return false;
        }
        this.field_220720_k = i;
        Entity target = this.attacker.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.attacker.hasFruit()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a(target, 0);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a(target, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.attacker.func_70092_e(target.func_226277_ct_(), target.func_174813_aQ().field_72338_b, target.func_226281_cx_());
    }

    public boolean func_75253_b() {
        Entity target = this.attacker.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.attacker.hasFruit()) {
            return false;
        }
        if (!this.attacker.isHungry()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_213389_a(target.func_233580_cy_())) {
            return false;
        }
        return !(target instanceof PlayerEntity) || !target.func_175149_v() && !((PlayerEntity)target).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.attacker.func_213395_q(true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        Entity target = this.attacker.getBoofloAttackTarget();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.attacker.setBoofloAttackTarget(null);
        }
        this.attacker.func_213395_q(false);
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        Entity target = this.attacker.getBoofloAttackTarget();
        this.attacker.func_70671_ap().func_75651_a(target, 10.0f, 10.0f);
        double distToEnemySqr = this.attacker.func_70092_e(target.func_226277_ct_(), target.func_174813_aQ().field_72338_b, target.func_226281_cx_());
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a(target)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = target.func_226277_ct_();
            this.targetY = target.func_174813_aQ().field_72338_b;
            this.targetZ = target.func_226281_cx_();
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (distToEnemySqr > 1024.0) {
                this.delayCounter += 10;
            } else if (distToEnemySqr > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a(target, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.tryToCapturePrey(target, distToEnemySqr);
    }

    protected void tryToCapturePrey(Entity prey, double distToEnemySqr) {
        double attackReach = this.getAttackReachSqr(prey);
        if (distToEnemySqr <= attackReach && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.setHasFruit(true);
            if (prey instanceof BolloomFruitEntity) {
                ((BolloomFruitEntity)prey).onBroken((Entity)this.attacker, false);
                prey.func_70106_y();
            }
        }
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }

    @Nullable
    public Path getPathToEntity(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        for (int y = 0; y < 8; ++y) {
            pos = pos.func_177979_c(y);
            if (entity.func_130014_f_().field_72995_K || !entity.func_130014_f_().func_180495_p(pos).func_200132_m() && entity.func_130014_f_().func_180495_p(pos).func_204520_s().func_206888_e()) continue;
            return this.attacker.func_70661_as().func_179680_a(pos, 0);
        }
        return this.attacker.func_70661_as().func_179680_a(entity.func_233580_cy_(), 0);
    }
}

