/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.puffbug.ai;

import endergeticexpansion.common.blocks.poise.BolloomBudBlock;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import endergeticexpansion.common.tileentities.BolloomBudTileEntity;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PuffBugTeleportToBudGoal
extends Goal {
    private static final int AREA_CHECK_SIZE = 26;
    private PuffBugEntity puffbug;
    private World world;

    public PuffBugTeleportToBudGoal(PuffBugEntity puffbug) {
        this.puffbug = puffbug;
        this.world = puffbug.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        BlockPos pos;
        BolloomBudTileEntity bud;
        if (!this.puffbug.func_184218_aH() && this.puffbug.func_70638_az() == null && this.puffbug.isNoEndimationPlaying() && this.puffbug.func_70681_au().nextInt(100) == 0 && !this.puffbug.hasLevitation() && !this.puffbug.func_70880_s() && !this.puffbug.wantsToRest() && this.puffbug.getTeleportController().canTeleport() && (bud = this.findNearbyBud()) != null && (pos = this.createUpperPosition(bud.func_174877_v())) != null && this.puffbug.getTeleportController().tryToCreateDesinationTo(pos, null)) {
            bud.setTeleportingBug(this.puffbug);
            this.puffbug.setBudPos(bud.func_174877_v());
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.puffbug.getTeleportController().processTeleportation();
        this.puffbug.func_213317_d(Vector3d.field_186680_a);
    }

    public void func_75246_d() {
        this.puffbug.func_213317_d(Vector3d.field_186680_a);
    }

    public boolean func_75253_b() {
        return !this.puffbug.func_70880_s() && this.puffbug.isEndimationPlaying(PuffBugEntity.TELEPORT_TO_ANIMATION);
    }

    @Nullable
    private BolloomBudTileEntity findNearbyBud() {
        BlockPos pos = this.puffbug.func_233580_cy_();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-26, -13, -26), (BlockPos)pos.func_177982_a(26, 13, 26))) {
            BolloomBudTileEntity bud;
            if (!blockpos.func_218137_a((IPosition)this.puffbug.func_213303_ch(), 26.0) || this.world.func_180495_p(blockpos).func_177230_c() != EEBlocks.BOLLOOM_BUD.get() || !(this.world.func_175625_s(blockpos) instanceof BolloomBudTileEntity) || ((Boolean)(bud = (BolloomBudTileEntity)this.world.func_175625_s(blockpos)).func_195044_w().func_177229_b((Property)BolloomBudBlock.OPENED)).booleanValue() || !this.isPathNotBlockedByEntity(bud) || bud.hasTeleportingBug() || !bud.canBeOpened()) continue;
            return bud;
        }
        return null;
    }

    @Nullable
    private BlockPos createUpperPosition(BlockPos pos) {
        BlockPos foundPos = null;
        for (int y = 1; y < 3; ++y) {
            if (!this.world.func_180495_p(pos.func_177981_b(y)).func_196952_d((IBlockReader)this.world, pos).func_197766_b() || !this.world.func_204610_c(pos.func_177981_b(y)).func_206888_e()) {
                foundPos = null;
                break;
            }
            foundPos = pos.func_177981_b(y);
        }
        return foundPos;
    }

    private boolean isPathNotBlockedByEntity(BolloomBudTileEntity bud) {
        return this.world.func_217357_a(Entity.class, new AxisAlignedBB(bud.func_174877_v()).func_72321_a(0.0, 3.0, 0.0)).isEmpty();
    }
}

