/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.nbt;

import endergeticexpansion.core.registry.EEItems;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SUpdateNBTTagMessage {
    private CompoundNBT tag;
    private String itemName;
    private boolean isVest;

    public SUpdateNBTTagMessage() {
    }

    public SUpdateNBTTagMessage(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            this.tag = stack.func_77978_p();
            this.itemName = stack.func_77977_a();
        }
        this.isVest = stack.func_77973_b() == EEItems.BOOFLO_VEST.get();
    }

    public void fromBytes(PacketBuffer buf) {
        this.tag = buf.func_150793_b();
        this.itemName = buf.func_150789_c(0x1FFFFFFF);
        this.isVest = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(this.tag);
        buf.func_180714_a(this.itemName);
        buf.writeBoolean(this.isVest);
    }

    public static void serialize(SUpdateNBTTagMessage message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SUpdateNBTTagMessage deserialize(PacketBuffer packet) {
        SUpdateNBTTagMessage message = new SUpdateNBTTagMessage();
        message.fromBytes(packet);
        return message;
    }

    public static boolean handle(SUpdateNBTTagMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack vest = player.func_184582_a(EquipmentSlotType.CHEST);
                if (message.isVest) {
                    if (!vest.func_190926_b() && vest.func_77973_b() == EEItems.BOOFLO_VEST.get()) {
                        vest.func_77982_d(message.tag);
                    }
                } else if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b().func_77658_a().equals(message.itemName)) {
                    player.field_71071_by.func_70448_g().func_77982_d(message.tag);
                }
            });
        }
        return true;
    }
}

