/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import endergeticexpansion.common.blocks.poise.hive.PuffBugHiveBlock;
import endergeticexpansion.common.blocks.poise.hive.PuffbugHiveHangerBlock;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class PuffBugHiveFeature
extends Feature<NoFeatureConfig> {
    private Supplier<BlockState> HIVE_STATE(boolean hanger) {
        return hanger ? () -> ((PuffbugHiveHangerBlock)EEBlocks.HIVE_HANGER.get()).func_176223_P() : () -> ((PuffBugHiveBlock)EEBlocks.PUFFBUG_HIVE.get()).func_176223_P();
    }

    public PuffBugHiveFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean func_230362_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (rand.nextFloat() < 0.1f) {
            return false;
        }
        BlockPos hivePos = pos.func_177977_b();
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == EEBlocks.POISE_LOG.get() || world.func_180495_p(pos.func_177984_a()).func_177230_c() == EEBlocks.POISE_LOG_GLOWING.get()) {
            if (world.func_180495_p(pos).func_185904_a().func_76222_j() && world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                world.func_180501_a(pos, this.HIVE_STATE(true).get(), 2);
                world.func_180501_a(hivePos, this.HIVE_STATE(false).get(), 2);
                this.spawnPuffBugs((IWorld)world, hivePos, rand);
                return true;
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == EEBlocks.POISE_CLUSTER.get() && world.func_217301_I() > 90 && world.func_180495_p(pos).func_185904_a().func_76222_j() && world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos, this.HIVE_STATE(true).get(), 2);
            world.func_180501_a(hivePos, this.HIVE_STATE(false).get(), 2);
            this.spawnPuffBugs((IWorld)world, hivePos, rand);
            return true;
        }
        return false;
    }

    private void spawnPuffBugs(IWorld world, BlockPos pos, Random rand) {
        int timesToRun = rand.nextInt(4) + 2;
        for (Direction openDirections : this.getOpenSides(world, pos)) {
            BlockPos offset = pos.func_177972_a(openDirections);
            PuffBugEntity puffbug = (PuffBugEntity)((EntityType)EEEntities.PUFF_BUG.get()).func_200721_a(world.func_201672_e());
            puffbug.func_70012_b((float)offset.func_177958_n() + 0.5f, (float)offset.func_177956_o() + 0.5f, (float)offset.func_177952_p() + 0.5f, 0.0f, 0.0f);
            puffbug.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
            puffbug.setHivePos(pos);
            world.func_217376_c((Entity)puffbug);
            if (timesToRun-- > 0) continue;
            break;
        }
    }

    private List<Direction> getOpenSides(IWorld world, BlockPos pos) {
        ArrayList openDirections = Lists.newArrayList();
        for (Direction directions : Direction.values()) {
            BlockPos offsetPos;
            if (directions == Direction.UP || !world.func_175623_d(offsetPos = pos.func_177972_a(directions)) || !world.func_175623_d(offsetPos.func_177984_a())) continue;
            openDirections.add(directions);
        }
        return openDirections;
    }
}

