/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core;

import endergeticexpansion.common.blocks.EnderFireBlock;
import endergeticexpansion.common.world.util.EndergeticLayerUtil;
import endergeticexpansion.core.registry.EEBiomes;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.layer.Layer;

public final class EEHooks {
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(direction -> direction.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static SimplexNoiseGenerator generator;
    private static Layer noiseBiomeLayer;

    public static Biome getEndergeticNoiseBiome(long seed, int x, int y, int z) {
        boolean isChorus;
        int j;
        int i;
        if (noiseBiomeLayer == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            sharedseedrandom.func_202423_a(17292);
            generator = new SimplexNoiseGenerator((Random)sharedseedrandom);
            noiseBiomeLayer = EndergeticLayerUtil.createGenLayers(seed)[1];
        }
        if ((long)(i = x >> 2) * (long)i + (long)(j = z >> 2) * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)generator, (int)(i * 2 + 1), (int)(j * 2 + 1));
        Biome biome = noiseBiomeLayer.func_215738_a(x, z);
        boolean bl = isChorus = biome == EEBiomes.CHORUS_PLAINS.get();
        if (f > 40.0f) {
            return isChorus ? Biomes.field_201938_R : biome;
        }
        if (f >= 0.0f) {
            return isChorus ? Biomes.field_201937_Q : biome;
        }
        return f < -20.0f ? Biomes.field_201936_P : (isChorus ? Biomes.field_201939_S : biome);
    }

    public static BlockState getFireForPlacement(IBlockReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        Block block = reader.func_180495_p(blockpos).func_177230_c();
        if (SoulFireBlock.func_235577_c_((Block)block)) {
            return Blocks.field_235335_bO_.func_176223_P();
        }
        if (EnderFireBlock.isEnderFireBase(block)) {
            return ((Block)EEBlocks.ENDER_FIRE.get()).func_176223_P();
        }
        return EEHooks.getNormalFirePlacement(reader, pos);
    }

    private static BlockState getNormalFirePlacement(IBlockReader reader, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        BlockState blockstate = reader.func_180495_p(downPos);
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        if (!fire.canCatchFire(reader, pos, Direction.UP) && !Block.func_220056_d((BlockState)blockstate, (IBlockReader)reader, (BlockPos)downPos, (Direction)Direction.UP)) {
            BlockState blockstate1 = fire.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.func_206870_a((Property)booleanproperty, (Comparable)Boolean.valueOf(fire.canCatchFire(reader, pos.func_177972_a(direction), direction.func_176734_d())));
            }
            return blockstate1;
        }
        return fire.func_176223_P();
    }

    public static BlockState getEnderCrystalFireForPlacement(IBlockReader reader, BlockPos pos) {
        return ((Block)EEBlocks.ENDER_FIRE.get()).func_176223_P();
    }

    public static Block getCrystalHolder() {
        return (Block)EEBlocks.CRYSTAL_HOLDER.get();
    }
}

