/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.events;

import com.google.common.collect.Maps;
import endergeticexpansion.common.blocks.CorrockBlock;
import endergeticexpansion.common.blocks.CorrockCrownBlock;
import endergeticexpansion.common.blocks.CorrockCrownStandingBlock;
import endergeticexpansion.common.blocks.CorrockCrownWallBlock;
import endergeticexpansion.common.blocks.CorrockPlantBlock;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endergetic")
public class PlayerEvents {
    public static final Map<Supplier<Block>, Supplier<Block>> PETRIFICATION_MAP = (Map)Util.func_200696_a((Object)Maps.newHashMap(), petrifications -> {
        petrifications.put(() -> (Block)EEBlocks.CORROCK_END.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_END.get());
        petrifications.put(() -> (Block)EEBlocks.CORROCK_NETHER.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_NETHER.get());
        petrifications.put(() -> (Block)EEBlocks.CORROCK_OVERWORLD.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_OVERWORLD.get());
        petrifications.put(() -> (Block)EEBlocks.CORROCK_END_BLOCK.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_END_BLOCK.get());
        petrifications.put(() -> (Block)EEBlocks.CORROCK_NETHER_BLOCK.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_NETHER_BLOCK.get());
        petrifications.put(() -> (Block)EEBlocks.CORROCK_OVERWORLD_BLOCK.get(), () -> (Block)EEBlocks.PETRIFIED_CORROCK_OVERWORLD_BLOCK.get());
        petrifications.put(() -> (CorrockCrownBlock)EEBlocks.CORROCK_CROWN_END_STANDING.get(), () -> (CorrockCrownBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_END_STANDING.get());
        petrifications.put(() -> (CorrockCrownBlock)EEBlocks.CORROCK_CROWN_NETHER_STANDING.get(), () -> (CorrockCrownBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_STANDING.get());
        petrifications.put(() -> (CorrockCrownBlock)EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING.get(), () -> (CorrockCrownBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_OVERWORLD_STANDING.get());
        petrifications.put(() -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_END_WALL.get(), () -> (CorrockCrownWallBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_END_WALL.get());
        petrifications.put(() -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_NETHER_WALL.get(), () -> (CorrockCrownWallBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_WALL.get());
        petrifications.put(() -> (CorrockCrownWallBlock)EEBlocks.CORROCK_CROWN_OVERWORLD_WALL.get(), () -> (CorrockCrownWallBlock)EEBlocks.PETRIFIED_CORROCK_CROWN_OVERWORLD_WALL.get());
    });

    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity projectileEntity = event.getThrowable();
        if (projectileEntity instanceof PotionEntity) {
            PotionEntity potionEntity = (PotionEntity)projectileEntity;
            ItemStack itemstack = potionEntity.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            if (potion == Potions.field_185230_b && list.isEmpty() && event.getRayTraceResult() instanceof BlockRayTraceResult) {
                World world = potionEntity.field_70170_p;
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)event.getRayTraceResult();
                Direction direction = blockraytraceresult.func_216354_b();
                BlockPos blockpos = blockraytraceresult.func_216350_a().func_177972_a(Direction.DOWN).func_177972_a(direction);
                PlayerEvents.tryToConvertCorrockBlock(world, blockpos);
                PlayerEvents.tryToConvertCorrockBlock(world, blockpos.func_177972_a(direction.func_176734_d()));
                for (Direction horizontals : Direction.Plane.HORIZONTAL) {
                    PlayerEvents.tryToConvertCorrockBlock(world, blockpos.func_177972_a(horizontals));
                }
            }
        }
    }

    private static void tryToConvertCorrockBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof CorrockPlantBlock && !((CorrockPlantBlock)block).petrified || block instanceof CorrockBlock && !((CorrockBlock)block).petrified || block instanceof CorrockCrownBlock && !((CorrockCrownBlock)block).petrified) {
            world.func_175656_a(pos, PlayerEvents.convertCorrockBlock(state));
        }
    }

    public static BlockState convertCorrockBlock(BlockState state) {
        Block block = state.func_177230_c();
        for (Map.Entry<Supplier<Block>, Supplier<Block>> entries : PETRIFICATION_MAP.entrySet()) {
            Block petrifiedBlock = entries.getValue().get();
            if (entries.getKey().get() != block) continue;
            if (block instanceof CorrockPlantBlock) {
                return (BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockPlantBlock.WATERLOGGED, state.func_177229_b((Property)CorrockPlantBlock.WATERLOGGED));
            }
            if (block instanceof CorrockBlock) {
                return petrifiedBlock.func_176223_P();
            }
            if (block instanceof CorrockCrownStandingBlock) {
                return (BlockState)((BlockState)((BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockCrownStandingBlock.ROTATION, state.func_177229_b((Property)CorrockCrownStandingBlock.ROTATION))).func_206870_a((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, state.func_177229_b((Property)CorrockCrownStandingBlock.UPSIDE_DOWN))).func_206870_a((Property)CorrockCrownStandingBlock.WATERLOGGED, state.func_177229_b((Property)CorrockCrownStandingBlock.WATERLOGGED));
            }
            return (BlockState)((BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockCrownWallBlock.WATERLOGGED, state.func_177229_b((Property)CorrockCrownWallBlock.WATERLOGGED))).func_206870_a((Property)CorrockCrownWallBlock.FACING, state.func_177229_b((Property)CorrockCrownWallBlock.FACING));
        }
        return null;
    }
}

