/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.network;

import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageS2CServerRedirect {
    private final String connectionAddress;

    public MessageS2CServerRedirect(String address) {
        this.connectionAddress = address;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_180714_a(this.connectionAddress);
    }

    public static MessageS2CServerRedirect deserialize(PacketBuffer buf) {
        return new MessageS2CServerRedirect(buf.func_218666_n());
    }

    public static void handle(MessageS2CServerRedirect message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> NetworkUtil.redirectToServer(message.getConnectionAddress()));
            context.setPacketHandled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getConnectionAddress() {
        return this.connectionAddress;
    }
}

