/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.network.particle;

import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageC2S2CSpawnParticle {
    public String particleName;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;

    public MessageC2S2CSpawnParticle(String particleName, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this.particleName = particleName;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_180714_a(this.particleName);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public static MessageC2S2CSpawnParticle deserialize(PacketBuffer buf) {
        String particleName = buf.func_150789_c(Short.MAX_VALUE);
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double motionX = buf.readDouble();
        double motionY = buf.readDouble();
        double motionZ = buf.readDouble();
        return new MessageC2S2CSpawnParticle(particleName, posX, posY, posZ, motionX, motionY, motionZ);
    }

    public static void handle(MessageC2S2CSpawnParticle message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> NetworkUtil.spawnParticle(message.particleName, message.posX, message.posY, message.posZ, message.motionX, message.motionY, message.motionZ));
        }
        context.setPacketHandled(true);
    }
}

