/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.world.storage.tracking;

import com.teamabnormals.abnormals_core.common.world.storage.tracking.TrackedData;
import com.teamabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public interface IDataManager {
    public <T> void setValue(TrackedData<T> var1, T var2);

    public <T> T getValue(TrackedData<T> var1);

    public boolean isDirty();

    public void clean();

    public void setDataMap(Map<TrackedData<?>, DataEntry<?>> var1);

    public Map<TrackedData<?>, DataEntry<?>> getDataMap();

    public Set<DataEntry<?>> getDirtyEntries();

    public Set<DataEntry<?>> getEntries(boolean var1);

    public static class DataEntry<T> {
        private TrackedData<T> trackedData;
        private T value;
        private boolean dirty;

        public DataEntry(TrackedData<T> trackedData) {
            this.trackedData = trackedData;
            this.value = trackedData.getDefaultValue();
        }

        public TrackedData<T> getTrackedData() {
            return this.trackedData;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
        }

        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(TrackedDataManager.INSTANCE.getId(this.trackedData));
            buffer.func_150786_a(this.writeValue());
        }

        public static DataEntry<?> read(PacketBuffer buffer) {
            int id = buffer.func_150792_a();
            TrackedData<?> trackedData = TrackedDataManager.INSTANCE.getTrackedData(id);
            Objects.requireNonNull(trackedData, String.format("Tracked Data does not exist for id %o", id));
            DataEntry entry = new DataEntry(trackedData);
            entry.readValue(buffer.func_150793_b(), true);
            return entry;
        }

        public CompoundNBT writeValue() {
            return this.getTrackedData().getProcessor().write(this.value);
        }

        public void readValue(CompoundNBT compound, boolean dirty) {
            this.value = this.getTrackedData().getProcessor().read(compound);
            this.dirty = dirty;
        }
    }
}

