/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.world.storage.tracking;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.teamabnormals.abnormals_core.common.world.storage.tracking.TrackedData;
import com.teamabnormals.abnormals_core.core.events.EntityTrackingEvent;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core")
public enum TrackedDataManager {
    INSTANCE;

    private final BiMap<ResourceLocation, TrackedData<?>> dataMap = HashBiMap.create();
    private final BiMap<Integer, TrackedData<?>> idMap = HashBiMap.create();
    private int nextId = 0;

    private TrackedDataManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public synchronized void registerData(ResourceLocation key, TrackedData<?> trackedData) {
        if (this.dataMap.containsKey((Object)key)) {
            throw new IllegalArgumentException(String.format("A Tracked Data with key '%s' is already registered!", key));
        }
        this.dataMap.put((Object)key, trackedData);
        this.idMap.put((Object)this.nextId, trackedData);
        ++this.nextId;
    }

    public <T> void setValue(Entity entity, TrackedData<T> trackedData, T value) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        ((IDataManager)entity).setValue(trackedData, value);
    }

    public <T> T getValue(Entity entity, TrackedData<T> trackedData) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        return ((IDataManager)entity).getValue(trackedData);
    }

    @Nullable
    public TrackedData<?> getTrackedData(ResourceLocation resourceLocation) {
        return (TrackedData)this.dataMap.get((Object)resourceLocation);
    }

    @Nullable
    public ResourceLocation getKey(TrackedData<?> trackedData) {
        return (ResourceLocation)this.dataMap.inverse().get(trackedData);
    }

    @Nullable
    public TrackedData<?> getTrackedData(int id) {
        return (TrackedData)this.idMap.get((Object)id);
    }

    public int getId(TrackedData<?> trackedData) {
        return (Integer)this.idMap.inverse().get(trackedData);
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getTarget();
        if (!target.field_70170_p.field_72995_K && !(entries = ((IDataManager)target).getEntries(true)).isEmpty()) {
            NetworkUtil.updateTrackedData((ServerPlayerEntity)event.getPlayer(), target, entries);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getEntity();
        if (!target.field_70170_p.field_72995_K && !(entries = ((IDataManager)target).getEntries(false)).isEmpty()) {
            NetworkUtil.updateTrackedData(target, entries);
        }
    }

    @SubscribeEvent
    public void onEntityTracked(EntityTrackingEvent event) {
        Entity entity = event.getEntity();
        IDataManager dataManager = (IDataManager)entity;
        if (event.isUpdating() || dataManager.isDirty()) {
            Set<IDataManager.DataEntry<?>> entries = dataManager.getDirtyEntries();
            if (!entries.isEmpty()) {
                if (entity instanceof ServerPlayerEntity) {
                    NetworkUtil.updateTrackedData((ServerPlayerEntity)entity, entity, entries);
                }
                NetworkUtil.updateTrackedData(entity, entries);
            }
            dataManager.clean();
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        if (!original.field_70170_p.field_72995_K) {
            Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = ((IDataManager)original).getDataMap();
            if (event.isWasDeath()) {
                dataMap.entrySet().removeIf(entry -> !((TrackedData)entry.getKey()).isPersistent());
            }
            dataMap.values().forEach(dataEntry -> dataEntry.markDirty());
            ((IDataManager)event.getPlayer()).setDataMap(dataMap);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IDataManager dataManager = (IDataManager)event.getPlayer();
        Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = dataManager.getDataMap();
        dataMap.values().forEach(dataEntry -> dataEntry.markDirty());
        ((IDataManager)event.getPlayer()).setDataMap(dataMap);
    }
}

