/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class ACConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    private static String makeTranslation(String name) {
        return "abnormals_core.config." + name;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class ValuesHolder {
        private static boolean quarkSignEditing;
        private static boolean signEditingRequireEmptyHand;
        private static boolean poisonPotatoCompatEnabled;
        private static boolean poisonEffect;
        private static double poisonChance;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            quarkSignEditing = (Boolean)ACConfig.COMMON.enableQuarkSignEditing.get();
            signEditingRequireEmptyHand = (Boolean)ACConfig.COMMON.signEditingRequiresEmptyHand.get();
            poisonPotatoCompatEnabled = (Boolean)ACConfig.COMMON.poisonPotatoCompatEnabled.get();
            poisonEffect = (Boolean)ACConfig.COMMON.poisonEffect.get();
            poisonChance = (Double)ACConfig.COMMON.poisonChance.get();
        }

        public static boolean isQuarkSignEditingEnabled() {
            return ModList.get().isLoaded("quark") && quarkSignEditing;
        }

        public static boolean doesSignEditingRequireEmptyHand() {
            return signEditingRequireEmptyHand;
        }

        public static boolean isPoisonPotatoCompatEnabled() {
            return poisonPotatoCompatEnabled;
        }

        public static boolean shouldPoisonEntity() {
            return poisonEffect;
        }

        public static double poisonEffectChance() {
            return poisonChance;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableQuarkSignEditing;
        public final ForgeConfigSpec.ConfigValue<Boolean> signEditingRequiresEmptyHand;
        public final ForgeConfigSpec.ConfigValue<Boolean> poisonPotatoCompatEnabled;
        public final ForgeConfigSpec.ConfigValue<Boolean> poisonEffect;
        public final ForgeConfigSpec.ConfigValue<Double> poisonChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common only settings for Abnormals Core, this will affect all depending mods").push("common");
            this.enableQuarkSignEditing = builder.comment("If Quark Sign Editing should be enabled; Default: True").translation(ACConfig.makeTranslation("quark_sign_editing")).define("quarkSignEditing", true);
            this.signEditingRequiresEmptyHand = builder.comment("If Quark Sign Editing requires an empty hand to edit; Default: False").translation(ACConfig.makeTranslation("require_empty_hand")).define("signEditingRequiresEmptyHand", false);
            builder.comment("Compatibility with Quark's poisonous potatoes feature").push("poisonousPotatoCompat");
            this.poisonPotatoCompatEnabled = builder.comment("If baby mobs can be fed a poisonous potato to stunt their growth when Quark is installed; Default: True").translation(ACConfig.makeTranslation("poison_potato_compat_enabled")).define("poisonPotatoCompatEnabled", true);
            this.poisonEffect = builder.comment("If growth stunting should give baby mobs poison; Default: True").translation(ACConfig.makeTranslation("poison_effect")).define("poisonEffect", true);
            this.poisonChance = builder.comment("The chance to stunt baby mob growth when feeding a poisonous potato; Default: 0.1").translation(ACConfig.makeTranslation("poison_chance")).defineInRange("poisonChance", 0.1, 0.0, 1.0);
            builder.pop();
            builder.pop();
        }
    }
}

