/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library.endimator;

import com.teamabnormals.abnormals_core.client.ClientInfo;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public final class ControlledEndimation {
    private int tick;
    private int prevTick;
    public int tickDuration;
    private boolean shouldDecrement;
    public boolean isPaused;

    public ControlledEndimation(int tickDuration, int startingValue) {
        this.tick = this.prevTick = startingValue;
        this.tickDuration = tickDuration;
    }

    public void update() {
        this.prevTick = this.tick;
    }

    public void tick() {
        if (this.isPaused) {
            return;
        }
        if (this.shouldDecrement && this.tick > 0) {
            --this.tick;
        } else if (!this.shouldDecrement && this.tick < this.tickDuration) {
            ++this.tick;
        }
    }

    public void setDecrementing(boolean shouldDecrement) {
        this.shouldDecrement = shouldDecrement;
    }

    public boolean isDecrementing() {
        return this.shouldDecrement;
    }

    public boolean isAtMax() {
        return this.tick == this.tickDuration;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int amount) {
        this.tick = this.prevTick = amount;
    }

    public void addTick(int amount) {
        this.tick += amount;
    }

    public void setTimerPaused(boolean paused) {
        this.isPaused = paused;
    }

    public void resetTimer() {
        this.prevTick = 0;
        this.tick = 0;
        this.isPaused = false;
        this.shouldDecrement = false;
    }

    public float getAnimationProgress() {
        return MathHelper.func_219799_g((float)ClientInfo.getPartialTicks(), (float)this.prevTick, (float)this.tick) / (float)this.tickDuration;
    }

    public float getAnimationProgressServer() {
        return MathHelper.func_219799_g((float)1.0f, (float)this.prevTick, (float)this.tick) / (float)this.tickDuration;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("Tick", this.tick);
        compound.func_74768_a("PrevTick", this.prevTick);
        compound.func_74757_a("ShouldDecrement", this.shouldDecrement);
        compound.func_74757_a("IsPaused", this.isPaused);
        return compound;
    }

    public void read(CompoundNBT nbt) {
        this.tick = nbt.func_74762_e("Tick");
        this.prevTick = nbt.func_74762_e("PrevTick");
        this.shouldDecrement = nbt.func_74767_n("ShouldDecrement");
        this.isPaused = nbt.func_74767_n("IsPaused");
    }
}

