/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class GenerationUtils {
    public static final Predicate<BlockState> IS_AIR = state -> state.func_196958_f();

    public static final Predicate<BlockState> IS_FLUID(int minLevel, Tag<Fluid> allowedFluids) {
        return state -> {
            FluidState fluid = state.func_204520_s();
            return !fluid.func_206888_e() && fluid.func_223408_f() >= (float)minLevel && fluid.func_206884_a((ITag)allowedFluids);
        };
    }

    public static void fillAreaWithBlockCube(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.Mutable positions = new BlockPos.Mutable();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.func_181079_c(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(world.func_180495_p((BlockPos)positions))) continue;
                    world.func_180501_a((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCube(IWorld world, Random rand, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, BlockPlacementEntry ... states) {
        BlockPos.Mutable positions = new BlockPos.Mutable();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.func_181079_c(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(world.func_180495_p((BlockPos)positions))) continue;
                    world.func_180501_a((BlockPos)positions, BlockPlacementEntry.getRandomState(rand, Arrays.asList(states)), 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block, @Nullable Predicate<BlockState> canPlace) {
        BlockPos.Mutable positions = new BlockPos.Mutable();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.func_181079_c(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(world.func_180495_p((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    world.func_180501_a((BlockPos)positions, block, 2);
                }
            }
        }
    }

    public static void fillAreaWithBlockCubeEdged(IWorld world, Random rand, int x1, int y1, int z1, int x2, int y2, int z2, @Nullable Predicate<BlockState> canPlace, BlockPlacementEntry ... states) {
        BlockPos.Mutable positions = new BlockPos.Mutable();
        for (int xx = x1; xx <= x2; ++xx) {
            for (int yy = y1; yy <= y2; ++yy) {
                for (int zz = z1; zz <= z2; ++zz) {
                    positions.func_181079_c(xx, yy, zz);
                    if (canPlace != null && !canPlace.test(world.func_180495_p((BlockPos)positions)) || xx != x2 && zz != z2) continue;
                    world.func_180501_a((BlockPos)positions, BlockPlacementEntry.getRandomState(rand, Arrays.asList(states)), 2);
                }
            }
        }
    }

    public static class BlockPlacementEntry {
        private final BlockState state;
        private final int weight;

        public BlockPlacementEntry(BlockState state, int weight) {
            this.state = state;
            this.weight = weight;
        }

        public static BlockState getRandomState(Random rand, List<BlockPlacementEntry> entries) {
            int randTotalWeight = rand.nextInt(BlockPlacementEntry.getTotalWeight(entries));
            for (int i = 0; i < entries.size(); ++i) {
                BlockPlacementEntry entry = entries.get(i);
                if ((randTotalWeight -= entry.weight) >= 0) continue;
                return entry.state;
            }
            return null;
        }

        private static int getTotalWeight(List<BlockPlacementEntry> entries) {
            int totalWeight = 0;
            for (BlockPlacementEntry entry : entries) {
                totalWeight += entry.weight;
            }
            return totalWeight;
        }
    }
}

