/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.utils;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ItemStackUtils {
    public static int findIndexOfItem(Item item, NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static void fillAfterItemForGroup(Item item, Item targetItem, ItemGroup group, NonNullList<ItemStack> items) {
        if (ItemStackUtils.isInGroup(item, group)) {
            int targetIndex = ItemStackUtils.findIndexOfItem(targetItem, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)item));
            } else {
                items.add((Object)new ItemStack((IItemProvider)item));
            }
        }
    }

    public static String intToRomanNumerals(int number) {
        String[] m = new String[]{"", "M", "MM", "MMM"};
        String[] c = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] x = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] i = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        String thousands = m[number / 1000];
        String hundereds = c[number % 1000 / 100];
        String tens = x[number % 100 / 10];
        String ones = i[number % 10];
        return thousands + hundereds + tens + ones;
    }

    public static boolean isInGroup(Item item, ItemGroup group) {
        if (item.getCreativeTabs().stream().anyMatch(tab -> tab == group)) {
            return true;
        }
        ItemGroup itemgroup = item.func_77640_w();
        return itemgroup != null && (group == ItemGroup.field_78027_g || group == itemgroup);
    }

    public static final class ItemStackBuilder {
        private final ItemStack stack;
        private final CompoundNBT tag;

        public ItemStackBuilder(ItemStack stack) {
            this.stack = stack;
            this.tag = stack.func_196082_o();
        }

        public ItemStackBuilder(IItemProvider item) {
            this(new ItemStack(item));
        }

        public ItemStackBuilder setCount(int count) {
            this.stack.func_190920_e(count);
            return this;
        }

        public ItemStackBuilder grow(int amount) {
            this.stack.func_190917_f(amount);
            return this;
        }

        public ItemStackBuilder shrink(int amount) {
            this.stack.func_190918_g(amount);
            return this;
        }

        public ItemStackBuilder setUnbreakable() {
            this.tag.func_74757_a("Unbreakable", true);
            return this;
        }

        public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
            this.stack.func_77966_a(enchantment, level);
            return this;
        }

        public ItemStackBuilder setName(@Nullable ITextComponent text) {
            this.stack.func_200302_a(text);
            return this;
        }

        public ItemStackBuilder addLore(ITextComponent text) {
            ListNBT loreListTag;
            CompoundNBT display = this.stack.func_190925_c("display");
            if (display.func_150297_b("Lore", 9)) {
                loreListTag = display.func_150295_c("Lore", 8);
            } else {
                loreListTag = new ListNBT();
                display.func_218657_a("Lore", (INBT)loreListTag);
            }
            loreListTag.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)text)));
            return this;
        }

        public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, @Nullable EquipmentSlotType slot) {
            this.stack.func_185129_a(attribute, modifier, slot);
            return this;
        }

        public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotType ... slots) {
            for (EquipmentSlotType slot : slots) {
                this.stack.func_185129_a(attribute, modifier, slot);
            }
            return this;
        }

        public ItemStackBuilder addPredicate(String key, String predicate) {
            ListNBT predicateList;
            if (this.tag.func_150297_b(key, 9)) {
                predicateList = this.tag.func_150295_c(key, 8);
            } else {
                predicateList = new ListNBT();
                this.tag.func_218657_a(key, (INBT)predicateList);
            }
            predicateList.add((Object)StringNBT.func_229705_a_((String)predicate));
            return this;
        }

        public ItemStackBuilder addCanDestroy(Block block) {
            return this.addPredicate("CanDestroy", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
        }

        public ItemStackBuilder addCanPlaceOn(Block block) {
            return this.addPredicate("CanPlaceOn", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
        }

        public ItemStack build() {
            return this.stack.func_77946_l();
        }
    }
}

