/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.utils;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public final class TreeUtils {
    public static void placeLogAt(IWorldWriter world, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        TreeUtils.setForcedState(world, pos, config.field_227368_m_.func_225574_a_(rand, pos));
    }

    public static void placeDirectionalLogAt(IWorldWriter world, BlockPos pos, Direction direction, Random rand, BaseTreeFeatureConfig config) {
        TreeUtils.setForcedState(world, pos, (BlockState)config.field_227368_m_.func_225574_a_(rand, pos).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()));
    }

    public static boolean isInTag(IWorldGenerationBaseReader world, BlockPos pos, ITag.INamedTag<Block> tag) {
        return world.func_217375_a(pos, block -> block.func_235714_a_((ITag)tag));
    }

    public static void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        if (TreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)world, pos)) {
            TreeUtils.setForcedState((IWorldWriter)world, pos, (BlockState)config.field_227369_n_.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
        }
    }

    public static void setForcedState(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 18);
    }

    public static boolean isAir(IWorldGenerationBaseReader world, BlockPos pos) {
        if (!(world instanceof IBlockReader)) {
            return world.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return world.func_217375_a(pos, state -> state.isAir((IBlockReader)world, pos));
    }

    public static boolean isLog(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    public static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        if (world instanceof IWorldReader) {
            return world.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)world, pos));
        }
        return world.func_217375_a(pos, state -> TreeUtils.isAir(world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static void setDirtAt(IWorld world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150458_ak) {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 18);
        }
    }

    public static boolean isValidGround(IWorld world, BlockPos pos, SaplingBlock sapling) {
        return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)sapling);
    }
}

