/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ravine.RavineCarver;
import java.util.BitSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class RavineController {
    private ISeedReader world;
    private SharedSeedRandom random = new SharedSeedRandom();
    private boolean isRavinesEnabled;
    private boolean isDebugViewEnabled;
    private ConfiguredCarver<ProbabilityConfig> ravineCarver;

    public RavineController(ISeedReader worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isRavinesEnabled = config.enableVanillaRavines.get();
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.ravineCarver = new ConfiguredCarver((WorldCarver)new RavineCarver(this.world, config, (Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), (ICarverConfig)new ProbabilityConfig(0.02f));
    }

    public void carveChunk(IChunk chunkIn, int chunkX, int chunkZ, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.isDebugViewEnabled || !this.isRavinesEnabled) {
            return;
        }
        for (int currChunkX = chunkX - 8; currChunkX <= chunkX + 8; ++currChunkX) {
            for (int currChunkZ = chunkZ - 8; currChunkZ <= chunkZ + 8; ++currChunkZ) {
                this.random.func_202425_c(this.world.func_72905_C(), currChunkX, currChunkZ);
                if (!this.ravineCarver.func_222730_a((Random)this.random, chunkX, chunkZ)) continue;
                ((RavineCarver)this.ravineCarver.field_222732_a).carve(chunkIn, (Random)this.random, this.world.func_181545_F(), currChunkX, currChunkZ, chunkX, chunkZ, liquidBlocks, biomeMap, airCarvingMask, liquidCarvingMask);
            }
        }
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
        ((RavineCarver)this.ravineCarver.field_222732_a).setWorld(worldIn);
    }
}

