/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;

public final class BlockHelper {
    private static BlockRayTraceResult rayTraceBlocks(World world, PlayerEntity player, double reach, RayTraceContext.FluidMode fluidMode) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vector3d eyePos = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vector3d vec3d1 = eyePos.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return world.func_217299_a(new RayTraceContext(eyePos, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    public static BlockRayTraceResult rayTraceBlocks(World world, PlayerEntity player) {
        return BlockHelper.rayTraceBlocks(world, player, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult rayTraceBlocks(World world, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        ModifiableAttributeInstance attribute = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        double reach = attribute != null ? attribute.func_111126_e() : 5.0;
        return BlockHelper.rayTraceBlocks(world, player, reach, fluidMode);
    }

    public static boolean breakBlocksAOE(ItemStack stack, World world, PlayerEntity player, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.func_201670_d()) {
            world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
        } else {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.func_201670_d() && player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.func_201670_d()) {
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity mplayer = (ServerPlayerEntity)player;
                int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)mplayer.field_71134_c.func_73081_b(), (ServerPlayerEntity)mplayer, (BlockPos)pos);
                if (xp == -1) {
                    return false;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (block.removedByPlayer(state, world, pos, player, true, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                    block.func_180657_a(world, player, pos, state, tile, stack);
                    block.func_180637_b(world, pos, xp);
                }
                mplayer.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
                return true;
            }
        } else {
            if (block.removedByPlayer(state, world, pos, player, true, state.func_204520_s())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            return true;
        }
        return false;
    }
}

