/*
 * Decompiled with CFR 0.152.
 */
package smelly.seekercompass;

import java.lang.reflect.Array;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import smelly.seekercompass.MessageS2CParticle;
import smelly.seekercompass.SeekerCompassItem;
import smelly.seekercompass.enchants.SCEnchants;

@Mod(value="seeker_compass")
public class SeekerCompass {
    public static final String MOD_ID = "seeker_compass";
    public static final Logger LOGGER = LogManager.getLogger((String)"seeker_compass".toUpperCase());
    public static final String NETWORK_PROTOCOL = "SC1";
    public static SeekerCompass instance;
    public static final SimpleChannel CHANNEL;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> SEEKER_COMPASS;

    public SeekerCompass() {
        instance = this;
        CHANNEL.messageBuilder(MessageS2CParticle.class, 0).encoder(MessageS2CParticle::serialize).decoder(MessageS2CParticle::deserialize).consumer(MessageS2CParticle::handle).add();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        SCEnchants.ENCHANTMENTS.register(modEventBus);
        modEventBus.addListener(this::setupCommon);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(EventPriority.LOWEST, this::setupClient));
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        ItemGroup.field_78040_i.func_111229_a(SeekerCompass.add(ItemGroup.field_78040_i.func_111225_m(), SCEnchants.SEEKER_COMPASS));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)SEEKER_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
                private double rotation;
                private double rota;
                private long lastUpdateTick;

                @OnlyIn(value=Dist.CLIENT)
                public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
                    CompoundNBT tag;
                    LivingEntity entity;
                    if (!SeekerCompassItem.isNotBroken(stack)) {
                        return 0.0f;
                    }
                    if (livingEntity == null && !stack.func_82839_y()) {
                        return 0.484375f;
                    }
                    boolean flag = livingEntity != null;
                    Object object = entity = flag ? livingEntity : stack.func_82836_z();
                    if (world == null) {
                        world = (ClientWorld)entity.field_70170_p;
                    }
                    if ((tag = stack.func_77978_p()) != null && tag.func_74764_b("Rotations") && tag.func_74764_b("EntityStatus") && !stack.func_82839_y()) {
                        return (float)SeekerCompassItem.positiveModulo(SeekerCompass.getSCRotation(stack), 1.0);
                    }
                    double randRotation = Math.random();
                    if (flag) {
                        randRotation = this.wobble(world, randRotation);
                    }
                    return (float)SeekerCompassItem.positiveModulo((float)randRotation, 1.0);
                }

                @OnlyIn(value=Dist.CLIENT)
                private double wobble(ClientWorld world, double rotation) {
                    if (world.func_82737_E() != this.lastUpdateTick) {
                        this.lastUpdateTick = world.func_82737_E();
                        double d0 = rotation - this.rotation;
                        d0 = SeekerCompassItem.positiveModulo(d0 + 0.5, 1.0) - 0.5;
                        this.rota += d0 * 0.1;
                        this.rota *= 0.8;
                        this.rotation = SeekerCompassItem.positiveModulo(this.rotation + this.rota, 1.0);
                    }
                    return this.rotation;
                }
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)SEEKER_COMPASS.get()), (ResourceLocation)new ResourceLocation("broken"), (stack, world, entity) -> SeekerCompassItem.isNotBroken(stack) ? 0.0f : 1.0f);
        });
    }

    private static double getSCRotation(ItemStack stack) {
        return SeekerCompassItem.RotationData.read((CompoundNBT)stack.func_77978_p().func_74775_l((String)"Rotations")).rotation;
    }

    private static EnchantmentType[] add(EnchantmentType[] array, EnchantmentType element) {
        EnchantmentType[] newArray = array;
        int arrayLength = Array.getLength(newArray);
        Object newArrayObject = Array.newInstance(newArray.getClass().getComponentType(), arrayLength + 1);
        System.arraycopy(array, 0, newArrayObject, 0, arrayLength);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    static {
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "net")).networkProtocolVersion(() -> NETWORK_PROTOCOL).clientAcceptedVersions(NETWORK_PROTOCOL::equals).serverAcceptedVersions(NETWORK_PROTOCOL::equals).simpleChannel();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        SEEKER_COMPASS = ITEMS.register(MOD_ID, () -> new SeekerCompassItem(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON).func_200916_a(ItemGroup.field_78040_i)));
    }
}

