/*
 * Decompiled with CFR 0.152.
 */
package smelly.seekercompass;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import smelly.seekercompass.MessageS2CParticle;
import smelly.seekercompass.SCEvents;
import smelly.seekercompass.SCTags;
import smelly.seekercompass.SeekerCompass;
import smelly.seekercompass.advancements.SCCriteriaTriggers;
import smelly.seekercompass.enchants.SCEnchants;

public class SeekerCompassItem
extends Item {
    private static final String VOODOO_TAG = "Voodoo";
    private static final String TRACKING_TAG = "TrackingEntity";
    private static final String ENTITY_TAG = "EntityStatus";
    private static final String ROTATIONS_TAG = "Rotations";
    private static final String TRACKING_ONLY = "TrackingOnly";

    public SeekerCompassItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && SeekerCompassItem.isNotBroken(stack)) {
            CompoundNBT tag = stack.func_77978_p();
            if (world.func_82737_E() % 20L == 0L && entity instanceof PlayerEntity && tag != null && tag.func_74764_b(TRACKING_TAG)) {
                PlayerEntity player = (PlayerEntity)entity;
                stack.func_222118_a(1, (LivingEntity)player, living -> living.func_213334_d(player.func_184600_cs()));
            }
            if (tag != null && tag.func_74764_b(VOODOO_TAG)) {
                VoodooData data = SeekerCompassItem.getVoodooData(tag);
                if (data.timer > 0) {
                    tag.func_218657_a(VOODOO_TAG, (INBT)VoodooData.write(new VoodooData(data.timesUsed, data.timer - 1)));
                } else if (data.timesUsed >= 9) {
                    tag.func_218657_a(VOODOO_TAG, (INBT)VoodooData.write(new VoodooData(0, 0)));
                }
            }
            if (tag != null && tag.func_74764_b(TRACKING_TAG)) {
                RotationData rotations;
                Entity trackingEntity = this.getEntity((ServerWorld)world, stack);
                if (trackingEntity != null) {
                    tag.func_218657_a(ENTITY_TAG, (INBT)EntityStatusData.write(trackingEntity));
                    CompoundNBT persistantData = trackingEntity.getPersistentData();
                    persistantData.func_74757_a("seeker_compass:chunk_update", true);
                    persistantData.func_74768_a("seeker_compass:chunk_timer", 20);
                    if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.PERSISTENCE.get()), (ItemStack)stack) > 0 && trackingEntity instanceof MobEntity) {
                        ((MobEntity)trackingEntity).func_110163_bv();
                    }
                } else if (tag.func_74764_b(ENTITY_TAG)) {
                    EntityStatusData data = EntityStatusData.read((CompoundNBT)tag.func_74781_a(ENTITY_TAG));
                    ChunkPos chunkpos = new ChunkPos(data.pos);
                    if (!SCEvents.isChunkForced((ServerWorld)world, chunkpos)) {
                        world.func_72863_F().func_217206_a(chunkpos, false);
                    }
                    tag.func_218657_a(ENTITY_TAG, (INBT)EntityStatusData.writeMissingEntity(data));
                }
                if (tag.func_74764_b(ROTATIONS_TAG)) {
                    double turn;
                    rotations = RotationData.read(tag.func_74775_l(ROTATIONS_TAG));
                    if (tag.func_74764_b(ENTITY_TAG)) {
                        double yaw = entity.field_70177_z;
                        yaw = SeekerCompassItem.positiveModulo(yaw / 360.0, 1.0);
                        double angle = this.getAngleToTrackedEntity(stack, entity) / 6.2831854820251465;
                        turn = 0.5 - (yaw - 0.25 - angle);
                    } else {
                        turn = Math.random();
                    }
                    Pair<Long, double[]> rotationData = this.wobble(world, turn, rotations.lastUpdateTick, rotations.rotation, rotations.rota);
                    rotations = new RotationData(((double[])rotationData.getSecond())[0], ((double[])rotationData.getSecond())[1], (Long)rotationData.getFirst());
                    tag.func_218657_a(ROTATIONS_TAG, (INBT)RotationData.write(rotations));
                } else {
                    double turn;
                    rotations = new RotationData(0.0, 0.0, 0L);
                    if (tag.func_74764_b(ENTITY_TAG)) {
                        double yaw = entity.field_70177_z;
                        yaw = SeekerCompassItem.positiveModulo(yaw / 360.0, 1.0);
                        double angle = this.getAngleToTrackedEntity(stack, entity) / 6.2831854820251465;
                        turn = 0.5 - (yaw - 0.25 - angle);
                    } else {
                        turn = Math.random();
                    }
                    Pair<Long, double[]> rotationData = this.wobble(world, turn, rotations.lastUpdateTick, rotations.rotation, rotations.rota);
                    rotations = new RotationData(((double[])rotationData.getSecond())[0], ((double[])rotationData.getSecond())[1], (Long)rotationData.getFirst());
                    tag.func_218657_a(ROTATIONS_TAG, (INBT)RotationData.write(rotations));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (SeekerCompassItem.isNotBroken(stack) && tag != null && !tag.func_74767_n(TRACKING_ONLY) && tag.func_74764_b(TRACKING_TAG) && tag.func_74764_b(ENTITY_TAG)) {
            EntityStatusData status = EntityStatusData.read(tag.func_74775_l(ENTITY_TAG));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.tracking_entity"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.entity_type").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)status.entityType, (Object[])new Object[0]))));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.entity_name").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(status.entityName)));
            boolean alive = status.isAlive;
            TextFormatting color = alive ? TextFormatting.GREEN : TextFormatting.RED;
            String aliveString = String.valueOf(alive);
            aliveString = aliveString.substring(0, 1).toUpperCase() + aliveString.substring(1).toLowerCase();
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.alive").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(aliveString).func_240699_a_(color)));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.health").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(status.health)).func_240699_a_(TextFormatting.GREEN)));
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.TRACKING.get()), (ItemStack)stack) > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.blockpos").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(status.pos.func_229422_x_())));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.standing_on").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)world.func_180495_p(status.pos.func_177977_b()).func_177230_c().func_149739_a(), (Object[])new Object[0]))));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.seeker_compass.biome").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)world.func_226691_t_(status.pos).func_210773_k(), (Object[])new Object[0]))));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasTag;
        ItemStack stack = player.func_184586_b(hand);
        CompoundNBT tag = stack.func_77978_p();
        boolean bl = hasTag = tag != null;
        if (hasTag && tag.func_74767_n(TRACKING_ONLY)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (SeekerCompassItem.isNotBroken(stack) && hasTag && tag.func_74764_b(TRACKING_TAG)) {
            double z;
            double y;
            Vector3d pos;
            double x;
            Entity entity;
            int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.VOODOO.get()), (ItemStack)stack);
            if (level > 0 && !SeekerCompassItem.getTargetEntity((Entity)player, 8).isPresent()) {
                Entity entity2;
                if (tag.func_74764_b(VOODOO_TAG) && SeekerCompassItem.getVoodooData((CompoundNBT)tag).timer > 0 && !player.func_184812_l_()) {
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.seeker_compass.voodoo_cooldown").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(SeekerCompassItem.getVoodooData((CompoundNBT)tag).timer)).func_240699_a_(TextFormatting.GOLD)), player.func_110124_au());
                    }
                    return ActionResult.func_226251_d_((Object)stack);
                }
                if (world instanceof ServerWorld && (entity2 = this.getEntity((ServerWorld)world, stack)) != null && entity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player).func_76348_h().func_82726_p(), 1.5f + (float)level)) {
                    SCCriteriaTriggers.VOODOO_MAGIC.trigger((ServerPlayerEntity)player);
                    Random rand = player.func_70681_au();
                    Vector3d targetPosition = entity2.func_213303_ch();
                    for (int i = 0; i < 8; ++i) {
                        Vector3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)entity2.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                        Vector3d motion = position.func_178788_d(targetPosition.func_72441_c(0.0, (double)(entity2.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                        SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
                    }
                    if (!player.func_184812_l_()) {
                        int damage = MathHelper.func_76125_a((int)(stack.func_77952_i() + 400), (int)0, (int)(stack.func_77958_k() - 1));
                        stack.func_196085_b(damage);
                        if (damage == stack.func_77958_k() - 1) {
                            player.func_213823_a(SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.5f, 1.5f);
                        }
                        VoodooData data = SeekerCompassItem.getVoodooData(tag);
                        int newTimesUsed = data.timesUsed + 1;
                        if (newTimesUsed >= 9) {
                            stack.func_77978_p().func_218657_a(VOODOO_TAG, (INBT)VoodooData.write(new VoodooData(9, 12000)));
                        } else {
                            stack.func_77978_p().func_218657_a(VOODOO_TAG, (INBT)VoodooData.write(new VoodooData(newTimesUsed, 0)));
                        }
                    }
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.WARPING.get()), (ItemStack)stack) > 0 && !SeekerCompassItem.getTargetEntity((Entity)player, 8).isPresent() && world instanceof ServerWorld && (entity = this.getEntity((ServerWorld)world, stack)) != null && player.func_213373_a(x = (pos = entity.func_213303_ch()).func_82615_a(), y = pos.func_82617_b(), z = pos.func_82616_c(), false)) {
                player.field_70143_R = 0.0f;
                world.func_184148_a(null, x, y, z, SoundEvents.field_187791_eX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                pos = player.func_213303_ch();
                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_warp", player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0));
                if (!player.func_184812_l_()) {
                    if (player.func_70681_au().nextFloat() < 0.25f) {
                        stack.func_190918_g(1);
                    }
                    stack.func_196085_b(1200);
                }
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean hasTag;
        ItemStack stack = context.func_195996_i();
        CompoundNBT tag = stack.func_77978_p();
        boolean bl = hasTag = tag != null;
        if (hasTag && tag.func_74767_n(TRACKING_ONLY)) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos placingPos = context.func_195995_a().func_177984_a();
        if (SeekerCompassItem.isNotBroken(stack) && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SCEnchants.SUMMONING.get()), (ItemStack)stack) > 0 && hasTag && tag.func_74764_b(TRACKING_TAG)) {
            Entity trackedEntity;
            if (world instanceof ServerWorld && ((trackedEntity = this.getEntity((ServerWorld)world, stack)) instanceof TameableEntity || SCTags.EntityTags.SUMMONABLES.func_230235_a_((Object)trackedEntity.func_200600_R())) && ((LivingEntity)trackedEntity).func_213373_a((double)((float)placingPos.func_177958_n() + 0.5f), (double)placingPos.func_177956_o(), (double)((float)placingPos.func_177952_p() + 0.5f), false)) {
                world.func_184148_a(null, (double)placingPos.func_177958_n(), (double)placingPos.func_177956_o(), (double)placingPos.func_177952_p(), SoundEvents.field_187791_eX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_warp", trackedEntity.func_226277_ct_(), trackedEntity.func_226278_cu_(), trackedEntity.func_226281_cx_(), 0.0, 0.0, 0.0));
                if (!player.func_184812_l_()) {
                    int damage = MathHelper.func_76125_a((int)(stack.func_77952_i() + 300), (int)0, (int)(stack.func_77958_k() - 1));
                    stack.func_196085_b(damage);
                    if (damage == stack.func_77958_k() - 1) {
                        player.func_213823_a(SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (tag == null || !tag.func_74764_b(TRACKING_TAG)) {
            boolean creative = player.func_184812_l_();
            if (world.func_180495_p(placingPos.func_177977_b()).func_177230_c() == Blocks.field_150343_Z && (player.field_71068_ca >= 10 || creative)) {
                if (!creative) {
                    player.field_71068_ca -= 10;
                }
                world.func_184148_a(null, (double)placingPos.func_177958_n(), (double)placingPos.func_177956_o(), (double)placingPos.func_177952_p(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.75f, 1.0f);
                if (world instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)world;
                    SCCriteriaTriggers.JOHN_CENA.trigger((ServerPlayerEntity)player);
                    for (ServerPlayerEntity players : serverWorld.func_217369_A()) {
                        for (int i = 0; i < players.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack itemstack = players.field_71071_by.func_70301_a(i);
                            if (itemstack.func_190926_b() || itemstack.func_77973_b() != this || !itemstack.func_77942_o() || !tag.func_74764_b(TRACKING_TAG) || player != this.getEntity(serverWorld, itemstack)) continue;
                            tag.func_82580_o(TRACKING_TAG);
                            tag.func_82580_o(ENTITY_TAG);
                            tag.func_82580_o(ROTATIONS_TAG);
                            Random rand = player.func_70681_au();
                            Vector3d targetPosition = players.func_213303_ch();
                            for (int i2 = 0; i2 < 8; ++i2) {
                                Vector3d position = targetPosition.func_72441_c(rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f), (double)players.func_70047_e(), rand.nextBoolean() ? (double)(-rand.nextFloat()) : (double)(rand.nextFloat() * 1.25f));
                                Vector3d motion = targetPosition.func_178788_d(position.func_72441_c(0.0, (double)(players.func_70047_e() * 0.35f), 0.0)).func_186678_a(-0.5);
                                SeekerCompass.CHANNEL.send(PacketDistributor.ALL.with(() -> null), (Object)new MessageS2CParticle("seeker_compass:seeker_eyes", targetPosition.func_82615_a(), targetPosition.func_82617_b(), targetPosition.func_82616_c(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
                            }
                            player.field_70170_p.func_184133_a(null, players.func_233580_cy_(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.75f, 1.5f);
                        }
                    }
                }
                stack.func_190918_g(1);
            }
        }
        return super.func_195939_a(context);
    }

    public boolean func_77616_k(ItemStack stack) {
        return !stack.func_77942_o() || !stack.func_77978_p().func_74767_n(TRACKING_ONLY);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151064_bs;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1200;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 16743936;
    }

    public static double positiveModulo(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static boolean isNotBroken(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    private Entity getEntity(ServerWorld world, ItemStack stack) {
        return world.func_217461_a(NBTUtil.func_186860_b((INBT)stack.func_77978_p().func_74781_a(TRACKING_TAG)));
    }

    private static VoodooData getVoodooData(CompoundNBT tag) {
        return VoodooData.read(tag.func_74775_l(VOODOO_TAG));
    }

    private double getAngleToTrackedEntity(ItemStack stack, Entity entity) {
        EntityStatusData data = EntityStatusData.read((CompoundNBT)stack.func_77978_p().func_74781_a(ENTITY_TAG));
        BlockPos pos = data.pos;
        return Math.atan2((double)pos.func_177952_p() - entity.func_226281_cx_(), (double)pos.func_177958_n() - entity.func_226277_ct_());
    }

    private Pair<Long, double[]> wobble(World world, double angle, long lastUpdateTickIn, double rotationIn, double rotaIn) {
        long lastUpdateTick = lastUpdateTickIn;
        double rotation = rotationIn;
        double rota = rotaIn;
        if (world.func_82737_E() != lastUpdateTick) {
            lastUpdateTick = world.func_82737_E();
            double d0 = angle - rotation;
            d0 = SeekerCompassItem.positiveModulo(d0 + 0.5, 1.0) - 0.5;
            rota += d0 * 0.1;
            rotation = SeekerCompassItem.positiveModulo(rotation + (rota *= 0.8), 1.0);
        }
        return Pair.of((Object)lastUpdateTick, (Object)new double[]{rotation, rota});
    }

    private static Optional<Entity> getTargetEntity(@Nullable Entity entityIn, int distance) {
        int i;
        Predicate<Entity> predicate;
        AxisAlignedBB axisalignedbb;
        Vector3d Vector3d1;
        Vector3d Vector3d2;
        if (entityIn == null) {
            return Optional.empty();
        }
        Vector3d Vector3d3 = entityIn.func_174824_e(1.0f);
        EntityRayTraceResult entityraytraceresult = SeekerCompassItem.rayTraceEntities(entityIn, Vector3d3, Vector3d2 = Vector3d3.func_178787_e(Vector3d1 = entityIn.func_70676_i(1.0f).func_186678_a((double)distance)), axisalignedbb = entityIn.func_174813_aQ().func_216361_a(Vector3d1).func_186662_g(1.0), predicate = p_217727_0_ -> !p_217727_0_.func_175149_v() && p_217727_0_.func_70067_L(), i = distance * distance);
        if (entityraytraceresult == null) {
            return Optional.empty();
        }
        return Vector3d3.func_72436_e(entityraytraceresult.func_216347_e()) > (double)i ? Optional.empty() : Optional.of(entityraytraceresult.func_216348_a());
    }

    @Nullable
    private static EntityRayTraceResult rayTraceEntities(Entity player, Vector3d p_221273_1_, Vector3d p_221273_2_, AxisAlignedBB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        World world = player.field_70170_p;
        double d0 = p_221273_5_;
        Entity entity = null;
        Vector3d Vector3d2 = null;
        for (Entity entity1 : world.func_175674_a(player, p_221273_3_, p_221273_4_)) {
            Vector3d Vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(p_221273_1_, p_221273_2_);
            if (axisalignedbb.func_72318_a(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                Vector3d2 = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.func_72436_e(Vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == player.func_184208_bv()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                Vector3d2 = Vector3d1;
                continue;
            }
            entity = entity1;
            Vector3d2 = Vector3d1;
            d0 = d1;
        }
        if (entity == null) {
            return null;
        }
        return new EntityRayTraceResult(entity, Vector3d2);
    }

    static class VoodooData {
        public final int timesUsed;
        public final int timer;

        public VoodooData(int timesUsed, int timer) {
            this.timer = timer;
            this.timesUsed = timesUsed;
        }

        public static VoodooData read(CompoundNBT compound) {
            return new VoodooData(compound.func_74762_e("TimesUsed"), compound.func_74762_e("Timer"));
        }

        public static CompoundNBT write(VoodooData data) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("TimesUsed", data.timesUsed);
            tag.func_74768_a("Timer", data.timer);
            return tag;
        }
    }

    static class RotationData {
        public final double rotation;
        private final double rota;
        private final long lastUpdateTick;

        public RotationData(double rotation, double rota, long lastUpdateTick) {
            this.rotation = rotation;
            this.rota = rota;
            this.lastUpdateTick = lastUpdateTick;
        }

        public static RotationData read(CompoundNBT compound) {
            return new RotationData(compound.func_74769_h("Rotation"), compound.func_74769_h("Rota"), compound.func_74763_f("LastUpdateTick"));
        }

        public static CompoundNBT write(RotationData data) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("Rotation", data.rotation);
            tag.func_74780_a("Rota", data.rota);
            tag.func_74772_a("LastUpdateTick", data.lastUpdateTick);
            return tag;
        }
    }

    static class EntityStatusData {
        public final boolean isAlive;
        public final float health;
        public final String entityType;
        public final String entityName;
        public final BlockPos pos;

        public EntityStatusData(boolean isAlive, float health, String entityType, String entityName, BlockPos pos) {
            this.isAlive = isAlive;
            this.health = health;
            this.entityType = entityType;
            this.entityName = entityName;
            this.pos = pos;
        }

        public static EntityStatusData read(CompoundNBT compound) {
            return new EntityStatusData(compound.func_74767_n("Alive"), compound.func_74760_g("Health"), compound.func_74779_i("EntityType"), compound.func_74779_i("EntityName"), NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)compound.func_74781_a("Pos"))));
        }

        public static CompoundNBT write(Entity trackingEntity) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Alive", trackingEntity.func_70089_S());
            tag.func_74778_a("EntityType", trackingEntity.func_200600_R().func_210760_d());
            tag.func_74778_a("EntityName", trackingEntity.func_200200_C_().getString());
            if (trackingEntity instanceof LivingEntity) {
                tag.func_74776_a("Health", ((LivingEntity)trackingEntity).func_110143_aJ());
            }
            tag.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)trackingEntity.func_233580_cy_()));
            return tag;
        }

        public static CompoundNBT writeMissingEntity(EntityStatusData status) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Alive", false);
            tag.func_74778_a("EntityType", status.entityType);
            tag.func_74778_a("EntityName", status.entityName);
            tag.func_74776_a("Health", 0.0f);
            tag.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)status.pos));
            return tag;
        }
    }
}

