/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.northerncompass.item.property;

import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class AngleCompassProperty
implements IItemPropertyGetter {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("angle");
    private final IItemPropertyGetter angleCompassProperty;

    public AngleCompassProperty(IItemPropertyGetter angleCompassProperty) {
        this.angleCompassProperty = angleCompassProperty;
    }

    public float call(ItemStack itemStack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
        if (CompassItem.func_234670_d_((ItemStack)itemStack)) {
            return this.angleCompassProperty.call(itemStack, world, entity);
        }
        if (entity == null && !itemStack.func_82839_y()) {
            return 0.0f;
        }
        Object currentEntity = entity != null ? entity : itemStack.func_82836_z();
        if (currentEntity == null) {
            return 0.0f;
        }
        Object currentWorld = world != null ? world : currentEntity.field_70170_p;
        if (currentWorld == null) {
            return 0.0f;
        }
        double rotation = currentEntity instanceof ItemFrameEntity ? this.getRotation((ItemFrameEntity)currentEntity) : this.getRotation((Entity)currentEntity);
        double angle = 360.0 - rotation;
        double modulo = MathHelper.func_191273_b((double)(angle / 360.0), (double)1.0);
        return (float)modulo;
    }

    private double getRotation(ItemFrameEntity itemFrameEntity) {
        Direction direction = itemFrameEntity.func_174811_aO();
        double entityRotation = direction == Direction.UP ? 0.0 : (direction == Direction.DOWN ? 180.0 : (double)(direction.func_176736_b() * 90));
        int itemRotation = itemFrameEntity.func_82333_j() * 45;
        return (entityRotation + (double)itemRotation) % 360.0;
    }

    private double getRotation(Entity entity) {
        return ((double)entity.field_70177_z + 180.0) % 360.0;
    }
}

