/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.DamageSourcePlane;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneInventoryBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class EntityPlaneDamageBase
extends EntityPlaneBase {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityPlaneDamageBase.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityPlaneDamageBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab()) {
            this.setPlaneDamage(this.getPlaneDamage() + 1.0f);
        }
        this.handleParticles();
    }

    protected void handleParticles() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (!((EntityPlaneSoundBase)this).isStarted()) {
            return;
        }
        Vector3d lookVec = this.func_70040_Z().func_72432_b().func_186678_a(1.5);
        double offX = lookVec.field_72450_a;
        double offY = lookVec.field_72448_b;
        double offZ = lookVec.field_72449_c;
        float damage = this.getPlaneDamage();
        float chance = Math.max(damage - 25.0f, 0.0f) / 100.0f;
        if (this.field_70146_Z.nextFloat() < chance) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, offX, offY, offZ);
        }
    }

    private void spawnParticle(IParticleData particleTypes, double offX, double offY, double offZ, double random) {
        this.field_70170_p.func_195594_a(particleTypes, this.func_226277_ct_() + offX + (this.field_70146_Z.nextDouble() * random - random / 2.0), this.func_226278_cu_() + offY + (this.field_70146_Z.nextDouble() * random - random / 2.0), this.func_226281_cx_() + offZ + (this.field_70146_Z.nextDouble() * random - random / 2.0), 0.0, 0.0, 0.0);
    }

    private void spawnParticle(IParticleData particleTypes, double offX, double offY, double offZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, 1.0);
    }

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        this.setPlaneDamage((float)((double)this.getPlaneDamage() + damage));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (!(source.func_76364_f() instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)source.func_76364_f();
        if (player == null) {
            return false;
        }
        if (this.func_184196_w((Entity)player)) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d && player.func_225608_bj_()) {
            this.destroyPlane(source, player);
            return true;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b().equals((Object)ModItems.WRENCH) && heldItem.func_77958_k() - heldItem.func_77952_i() >= 512) {
            heldItem.func_222118_a(512, (LivingEntity)player, playerEntity -> {});
            this.destroyPlane(source, player);
        }
        return false;
    }

    public void destroyPlane(DamageSource source, PlayerEntity player) {
        IInventory inventory = ((EntityPlaneInventoryBase)this).getInventory();
        InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (IInventory)inventory);
        inventory.func_174888_l();
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.getLootTable());
        LootContext.Builder context = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_216283_c, (Object)source).func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216285_e, (Object)player);
        loottable.func_216120_b(context.func_216022_a(LootParameterSets.field_216263_d), arg_0 -> ((EntityPlaneDamageBase)this).func_199701_a_(arg_0));
        this.func_70106_y();
    }

    public abstract ResourceLocation getLootTable();

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getPlaneDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setPlaneDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    @Override
    public boolean func_241849_j(Entity entity) {
        double speed;
        if (entity instanceof LivingEntity && !this.func_184188_bt().contains(entity) && entity.func_174813_aQ().func_72326_a(this.func_174813_aQ()) && (speed = this.func_213322_ci().func_72433_c()) > (double)0.35f) {
            float damage = Math.min((float)(speed * 10.0), 15.0f);
            entity.func_70097_a((DamageSource)DamageSourcePlane.DAMAGE_PLANE, damage);
        }
        return super.func_241849_j(entity);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPlaneDamage(compound.func_74760_g("Damage"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Damage", this.getPlaneDamage());
    }
}

